% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert_to_imeca}
\alias{convert_to_imeca}
\title{Convert pollution values in the original units returned by sensors to
IMECA (Indice Metropolitano de la Calidad del Aire), a dimensionless scale
where all the pollutants can be compared.}
\usage{
convert_to_imeca(value, pollutant, showWarnings = TRUE)
}
\arguments{
\item{value}{value to convert to IMECAS}

\item{pollutant}{type of pollutant}

\item{showWarnings}{show a warning about issues with performing the conversion}
}
\value{
value in IMECAS
}
\description{
See \url{http://rama.edomex.gob.mx/contaminacion-atmosferica/imeca}
}
\examples{
## IMECAs are a dimensionless scale that allows for the comparison of
## different pollutants
convert_to_imeca(157, "O3", showWarnings = FALSE)
convert_to_imeca(c(450, 350, 250), "NO2", showWarnings = FALSE)
convert_to_imeca(80, "PM10", showWarnings = FALSE)
convert_to_imeca(c(157, 200), "O3", showWarnings = FALSE)
convert_to_imeca(48, "O3", showWarnings = FALSE)
convert_to_imeca(67, "O3", showWarnings = FALSE)
convert_to_imeca(77, "O3", showWarnings = FALSE)
convert_to_imeca(205, "O3", showWarnings = FALSE)
convert_to_imeca(72, "O3", showWarnings = FALSE)
convert_to_imeca(98, "O3", showWarnings = FALSE)

## Should show a warning because the conversion formula is not well
## defined
convert_to_imeca(1.5, "CO")

}
