% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R
\docType{methods}
\name{data.frame}
\alias{data.frame}
\alias{as.data.frame,TimeSeries-method}
\title{Coerce to a Data Frame}
\usage{
\S4method{as.data.frame}{TimeSeries}(x, ..., calendar = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeSeries}} object.}

\item{...}{Further parameters to be passed to \code{\link[=data.frame]{data.frame()}}.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}). If \code{NULL} (the default), \emph{rata die} are returned.}
}
\value{
A long \code{\link{data.frame}} with the following columns:
\describe{
\item{\code{time}}{The (decimal) years at which the time series was sampled.}
\item{\code{series}}{The name of the time series.}
\item{\code{variable}}{The name of the variables.}
\item{\code{value}}{The observed value.}
}
}
\description{
Coerce to a Data Frame
}
\examples{
## Create time-series of 20 observations

## Univariate
## Sampled every years starting from 1029 BCE
(X <- series(rnorm(30), time = 1029:1000, calendar = BCE()))

## Terminal and sampling times (returns rata die)
start(X)
end(X)
time(X)
span(X)

## Multivariate
## Sampled every century starting from 1000 CE
(Y <- series(matrix(rnorm(90), 30, 3), time = 1000:1029, calendar = CE()))

## Terminal and sampling times (returns Gregorian Common Era years)
start(Y, calendar = CE())
end(Y, calendar = CE())
time(Y, calendar = CE())
span(Y, calendar = CE())

## Coerce to data frame
df <- as.data.frame(Y, calendar = BP())
head(df)
}
\seealso{
Other time series tools: 
\code{\link{series}()},
\code{\link{span}()},
\code{\link{start}()},
\code{\link{time}()},
\code{\link{window}()}
}
\author{
N. Frerebeau
}
\concept{time series tools}
