% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_apce.R
\name{PlotAPCE}
\alias{PlotAPCE}
\title{Plot APCE}
\usage{
PlotAPCE(
  res,
  y.max = 0.1,
  decision.labels = c("signature bond", "small cash bond", "large cash bond"),
  shape.values = c(16, 17, 15),
  col.values = c("blue", "black", "red", "brown"),
  label = TRUE,
  r.labels = c("safe", "easily\\npreventable", "prevent-\\nable", "risky\\n"),
  label.position = c("top", "top", "top", "top"),
  top.margin = 0.01,
  bottom.margin = 0.01,
  name.group = c("Overall", "Female", "Male", "Non-white\\nMale", "White\\nMale"),
  label.size = 4
)
}
\arguments{
\item{res}{A \code{data.frame} generated with \code{APCEsummary()}.}

\item{y.max}{Maximum value of y-axis.}

\item{decision.labels}{Labels of decisions (D).}

\item{shape.values}{Shape of point for each decisions.}

\item{col.values}{Color of point for each principal stratum.}

\item{label}{A logical argument whether to specify label of each principal stratum. The default is \code{TRUE}.}

\item{r.labels}{Label of each principal stratum.}

\item{label.position}{The position of labels.}

\item{top.margin}{Top margin of labels.}

\item{bottom.margin}{Bottom margin of labels.}

\item{name.group}{A character vector including the labels of five subgroups.}

\item{label.size}{Size of label.}
}
\value{
A ggplot.
}
\description{
See Figure 4 for example.
}
\examples{
\donttest{
data(synth)
sample_mcmc <- AiEvalmcmc(data = synth, n.mcmc = 10)
subgroup_synth <- list(
  1:nrow(synth), which(synth$Sex == 0), which(synth$Sex == 1),
  which(synth$Sex == 1 & synth$White == 0), which(synth$Sex == 1 & synth$White == 1)
)
sample_apce <- CalAPCE(
  data = synth, mcmc.re = sample_mcmc,
  subgroup = subgroup_synth
)
sample_apce_summary <- APCEsummary(sample_apce[["APCE.mcmc"]])
PlotAPCE(sample_apce_summary,
  y.max = 0.25, decision.labels = c(
    "signature", "small cash",
    "middle cash", "large cash"
  ), shape.values = c(16, 17, 15, 18),
  col.values = c("blue", "black", "red", "brown", "purple"), label = FALSE
)
}

}
