% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness.R
\name{PlotFairness}
\alias{PlotFairness}
\title{Plot the principal fairness}
\usage{
PlotFairness(
  res,
  top.margin = 0.01,
  y.max = 0.2,
  y.min = -0.1,
  r.labels = c("Safe", "Easily\\nPreventable", "Preventable", "Risky"),
  label = TRUE
)
}
\arguments{
\item{res}{The data frame generated from \code{CalFairness}.}

\item{top.margin}{The index of subgroups (within the output of CalAPCE/CalAPCEparallel) that corresponds to the protected attributes.}

\item{y.max}{Maximum value of y-axis.}

\item{y.min}{Minimum value of y-axis.}

\item{r.labels}{Label of each principal stratum.}

\item{label}{A logical argument whether to specify label.}
}
\value{
A \code{data.frame} of the delta.
}
\description{
See Figure 5 for example.
}
\examples{
\donttest{
data(synth)
subgroup_synth = list(1:nrow(synth), which(synth$Sex==0), which(synth$Sex==1), 
                      which(synth$Sex==1&synth$White==0), which(synth$Sex==1&synth$White==1))
sample_mcmc = AiEvalmcmc(data = synth, n.mcmc = 10)
sample_apce = CalAPCE(data = synth, mcmc.re = sample_mcmc, subgroup = subgroup_synth, 
                      burnin = 0)
sample_fair = CalFairness(sample_apce)
PlotFairness(sample_fair, y.max = 0.4, y.min = -0.4, r.labels = c("Safe", "Preventable 1", 
             "Preventable 2", "Preventable 3", "Risky"))
}

}
