\name{nass.corn}
\alias{nass.barley}
\alias{nass.corn}
\alias{nass.cotton}
\alias{nass.hay}
\alias{nass.rice}
\alias{nass.sorghum}
\alias{nass.soybean}
\alias{nass.wheat}
\docType{data}
\title{
  U.S. historical crop yields by state
}
\description{
  Yields and acres harvested in each state for the major agricultural
  crops, from approximately 1900 to 2011.  Crops include: barley, corn,
  cotton, hay, rice, sorghum, soybeans, wheat.
}
\usage{data(nass.corn)}
\format{
  \describe{
    \item{\code{year}}{Year, numeric}
    \item{\code{state}}{State factor}
    \item{\code{acres}}{Acres harvested}
    \item{\code{yield}}{Average yield}
  }
}
\details{
  Be cautious with yield values for states with small acres harvested.

  Yields are in bushels/acre, except: cotton pounds/acre, hay tons/acre,
  rice pounds/acre.
}
\source{
  United States Department of Agriculture,
  National Agricultural Statistics Service.
  \url{http://quickstats.nass.usda.gov/}
}
\examples{
dat <- nass.corn

# Use only states that grew at least 100K acres of corn in 2011
keep <- droplevels(subset(dat, year == 2011 & acres > 100000))$state
dat <- droplevels(subset(dat, is.element(state, keep)))

# Acres of corn grown each year
xyplot(acres ~ year|state, dat, type='l', as.table=TRUE,
title="State trends in corn acreage")

# Plain levelplot, using only states
datm <- acast(dat, year~state, value.var='yield')
levelplot(datm, aspect=.5, col.regions=RedGrayBlue,
          scales=list(x=list(rot=90, cex=.7)))

\dontrun{
library("mvtsplot")
mvtsplot(datm, levels=11, margin=FALSE, norm='global')
}

# Model the rate of genetic gain in Illinois as a piecewise regression
# Breakpoints define periods of open-pollinated varieties, double-cross,
# single-cross, and transgenic hybrids.

dil <- subset(nass.corn, state=="Illinois" & year >= 1900)
m1 <- lm(yield ~ pmin(year,1932) + pmax(1932, pmin(year, 1959)) +
         pmax(1959, pmin(year, 1995)) + pmax(1995, year), dil)
signif(coef(m1)[-1],3) # Rate of gain for each segment
plot(yield ~ year, dil, main="Piecewise linear model of Illinois corn yields")
lines(dil$year, fitted(m1))
abline(v=c(1932,1959,1995), col="wheat")

}
\keyword{datasets}
