% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{make_polygons}
\alias{make_polygons}
\title{make_polygons}
\usage{
make_polygons(
  ggplot_object,
  north = 3454206.89,
  east = 5939183.21,
  projection_input = "+init=epsg:31467",
  projection_output = "+init=epsg:4326"
)
}
\arguments{
\item{ggplot_object}{saved ggplot object, containing the
coordinates of the rectangles of a 'ggplot' object of the first two layers}

\item{north}{float added to the rows
to have a northing ordinate}

\item{east}{float added to the rows
to have a easting ordinate}

\item{projection_input}{string defines
in which EPSG projection the ggplot object should be converted to a raster object?
a projection with a metric unit is highly recommended}

\item{projection_output}{string defines
in which EPSG projection the SpatialPolygonDataFrame should be exported.}
}
\value{
a SpatialPolygonDataFrame object
}
\description{
This function coerces all rectangles
from a 'ggplot' object to 'SpatialPolygonDataFrame'.
}
\examples{
library(agricolaeplotr)
library(agricolae)
trt = c(2,3,4)
outdesign1 <-design.crd(trt,r=5,serie=2,2543,'Mersenne-Twister')
plt <- plot_design_crd(outdesign1,ncols = 13,nrows = 3)
spat_df <- make_polygons(plt)
spat_df
}
