% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{compute_pdf_and_cdf}
\alias{compute_pdf_and_cdf}
\alias{compute_pdf_and_cdf.default}
\alias{compute_pdf_and_cdf.list}
\alias{compute_pdf_and_cdf.aghq}
\title{Density and Cumulative Distribution Function}
\usage{
compute_pdf_and_cdf(obj, ...)

\method{compute_pdf_and_cdf}{default}(
  obj,
  transformation = default_transformation(),
  finegrid = NULL,
  interpolation = "auto",
  ...
)

\method{compute_pdf_and_cdf}{list}(obj, transformation = default_transformation(), ...)

\method{compute_pdf_and_cdf}{aghq}(obj, transformation = obj$transformation, ...)
}
\arguments{
\item{obj}{Either the output of \code{aghq::aghq()}, its list of marginal distributions
(element \code{marginals}), or an individual \code{data.frame} containing one of
these marginal distributions as output by \code{aghq::marginal_posterior()}.}

\item{...}{Used to pass additional arguments.}

\item{transformation}{Optional. Calculate pdf/cdf for a transformation of the parameter
whose posterior was normalized using adaptive quadrature.
\code{transformation} is either: a) an \code{aghqtrans} object returned by \code{aghq::make_transformation},
or b) a list that will be passed to that function internally. See \code{?aghq::make_transformation} for details.}

\item{finegrid}{Optional, a grid of values on which to compute the CDF. The default makes
use of the values in \code{margpost} but if the results are unsuitable, you may wish to
modify this manually.}

\item{interpolation}{Which method to use for interpolating the marginal posterior, \code{'polynomial'} (default)
or \code{'spline'}? If \code{k > 3} then the polynomial may be unstable and you should use the spline, but the spline
doesn't work \emph{unless} \code{k > 3} so it's not the default. See \code{interpolate_marginal_posterior()}.}
}
\value{
A tbl_df/tbl/data.frame with columns \code{theta}, \code{pdf} and \code{cdf} corresponding
to the value of the parameter and its estimated PDF and CDF at that value.
}
\description{
Compute the density and cumulative distribution function of the approximate posterior.
The density is approximated on a find grid using a polynomial interpolant.
The CDF can't be computed exactly (if it could, you wouldn't be using quadrature!),
so a fine grid is laid down and the CDF is approximated at each grid point
using a simpler integration rule and a polynomial interpolant. This method tends
to work well, but won't always.
}
\examples{
logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)
opt_sparsetrust_2d <- optimize_theta(funlist2d,c(1.5,1.5))
margpost <- marginal_posterior(opt_sparsetrust_2d,3,1) # margpost for theta1
thepdfandcdf <- compute_pdf_and_cdf(margpost)
with(thepdfandcdf,{
  plot(pdf~theta,type='l')
  plot(cdf~theta,type='l')
})

}
\seealso{
Other summaries: 
\code{\link{compute_quantiles}()},
\code{\link{interpolate_marginal_posterior}()},
\code{\link{marginal_posterior}()}
}
\concept{summaries}
