% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\name{add_an_admixture}
\alias{add_an_admixture}
\title{Adds a new admixture event to a graph.}
\usage{
add_an_admixture(graph, admixture_variable_name, labels_matter = FALSE,
  outgroup = "")
}
\arguments{
\item{graph}{An admixture graph.}

\item{admixture_variable_name}{A name for the new admixture proportion.}

\item{labels_matter}{When \code{FALSE} (the default value), we consider two admixture
graphs similar when they have the same topology but permuted
admixture proportion names. When \code{TRUE}, the already existing
admixture events and the edges leading to them are considered
labeled.}

\item{outgroup}{An optional parameter for the preferred outgroup.}
}
\value{
A list of graphs made by adding a new admixture event to the input graph. The list has
        no duplicate elements (what that means depends on the value of \code{labels_matter}).
}
\description{
Given an admixture graph, selects a child edge and a parent edges and adds a new edge from the 
parent edge to the childedge with an admixture event, if possible. 
Thus, the resulting graph is an extension of the input graph in the sense that erasing one of
the admixture edges (the new one) we get the original admixture graph. However, we know that 
in practice when fitting data to admixture graphs, the best graph with \eqn{k} admixture events
is not always an extension like that from the best graph with \eqn{k - 1} admixture events.
For a more relaxed way of adding a new admixture event, try \code{\link{add_an_admixture2}}.
}
\examples{
\donttest{
# To illustrate what the parameter labels_matter does, consider the following graph:

leaves <- c("A", "B", "C")
inner_nodes <- c("R", "x", "y", "M")
edges <- parent_edges(c(edge("x", "R"),
                        edge("y", "R"),
                        edge("A", "x"),
                        edge("B", "M"),
                        edge("C", "y"),
                        admixture_edge("M", "x", "y")))
admixtures <- admixture_proportions(c(admix_props("M", "x", "y", "p")))
graph <- agraph(leaves, inner_nodes, edges, admixtures)
plot(graph, show_admixture_labels = TRUE, title = "graph")

# There are 15 ways this graph can be extended to a graph with two admixture events by
# adding an admixture edge, as can be seeing by having the program explicitly construct
# all the cases:

short_list <- add_an_admixture(graph, "q")
print(length(short_list))

# However, maybe we already have a specific historical event in mind corresponding to the
# original admixture event in graph, or a fixed value for the admixture proportion p.
# Then, for example, it makes a difference to us whether we consider the possibility of
# another admixture event occurring before that event,

leaves <- c("A", "B", "C")
inner_nodes <- c("R", "x", "y", "z", "M", "N")
edges <- parent_edges(c(edge("x", "R"),
                        edge("z", "R"),
                        edge("y", "z"),
                        edge("A", "x"),
                        edge("B", "M"),
                        edge("C", "y"),
                        admixture_edge("N", "x", "z"),
                        admixture_edge("M", "N", "y")))
admixtures <- admixture_proportions(c(admix_props("N", "x", "z", "q"),
                                      admix_props("M", "N", "y", "p")))
example1 <- agraph(leaves, inner_nodes, edges, admixtures)
plot(example1, show_admixture_labels = TRUE, title = "example 1")

# or after that event,

leaves <- c("A", "B", "C")
inner_nodes <- c("R", "x", "y", "z", "M", "N")
edges <- parent_edges(c(edge("x", "R"),
                        edge("y", "R"),
                        edge("z", "y"),
                        edge("A", "x"),
                        edge("B", "N"),
                        edge("C", "z"),
                        admixture_edge("M", "x", "y"),
                        admixture_edge("N", "M", "z")))
admixtures <- admixture_proportions(c(admix_props("M", "x", "y", "p"),
                                      admix_props("N", "M", "z", "q")))
example2 <- agraph(leaves, inner_nodes, edges, admixtures)
plot(example2, show_admixture_labels = TRUE, title = "example 2")

# even though as (acyclic) directed graphs with labeled leaves example 1
# and example 2 are isomorphic.
# Counting cases like that dirrerent, we get 21 possible extensions:

long_list <- add_an_admixture(graph, "q", labels_matter = TRUE)
print(length(long_list))
}

}
\seealso{
\code{\link{make_permutations}}

\code{\link{four_leaves_graphs}}

\code{\link{five_leaves_graphs}}

\code{\link{six_leaves_graphs}}

\code{\link{seven_leaves_trees}}

\code{\link{eight_leaves_trees}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}
}

