% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVdk_varCov_estimators.R
\name{BVdk_varCov_estimators}
\alias{BVdk_varCov_estimators}
\title{Variance of estimators in an admixture model with symmetric unknown density.}
\usage{
BVdk_varCov_estimators(estim, data, admixMod)
}
\arguments{
\item{estim}{An object of class 'estim_BVdk', containing the estimators of unknown quantities in the admixture model.}

\item{data}{The observed sample under study.}

\item{admixMod}{An object of class 'admix_model', containing useful information about distributions and parameters.}
}
\value{
A list containing 1) the variance-covariance matrix of the estimators (assessed at the specific time points 'u' and 'v'
such that u = v = mean(data)); 2) the variance of the estimator of the unknown mixture weight; 3) the variance of the
estimator of the location shift parameter; 4) the variance of the estimator of the unknown component cumulative
distribution function at points 'u' and 'v'.
}
\description{
Semiparametric estimation of the variance of the estimators related to the mixture weight p and the location shift parameter mu,
considering the admixture model with probability density function l:
l(x) = p*f(x-mu) + (1-p)*g(x), x in R,
where g is the known component of the two-component mixture, p is the unknown proportion, f is the unknown component density and
mu is the location shift. See 'Details' below for more information.
}
\details{
See formulas pp.28--30 in Appendix of Bordes, L. and Vandekerkhove, P. (2010).
}
\examples{
## Simulate mixture data:
mixt1 <- twoComp_mixt(n = 200, weight = 0.4,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(c("mean" = -2, "sd" = 0.5),
                                        c("mean" = 0, "sd" = 1)))
data1 <- getmixtData(mixt1)
## Define the admixture model:
admixMod <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                        knownComp_param = mixt1$comp.param[[2]])

## Perform the estimation of parameters in real-life:
estim <- estim_BVdk(data = data1, admixMod = admixMod, method = 'L-BFGS-B')
BVdk_varCov_estimators(estim = estim, data = data1, admixMod = admixMod)

}
\references{
\insertRef{BordesVandekerkhove2010}{admix}
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
