% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_filter_cond}
\alias{assert_filter_cond}
\title{Is an Argument a Filter Condition?}
\usage{
assert_filter_cond(arg, optional = FALSE)
}
\arguments{
\item{arg}{Quosure - filtering condition.}

\item{optional}{Logical - is the argument optional? Defaults to \code{FALSE}.}
}
\value{
Performs necessary checks and returns \code{arg} if all pass.
Otherwise throws an informative error.
}
\description{
Is an Argument a Filter Condition?
}
\details{
Check if \code{arg} is a suitable filtering condition to be used in
functions like \code{subset} or \code{dplyr::filter}.
}
\examples{
library(admiral.test)
data(admiral_dm)

# typical usage in a function as a parameter check
example_fun <- function(dat, x) {
  x <- assert_filter_cond(rlang::enquo(x))
  dplyr::filter(dat, !!x)
}

example_fun(admiral_dm, AGE == 64)

try(example_fun(admiral_dm, USUBJID))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_expr}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_has_variables}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_order_vars}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\author{
Ondrej Slama
}
\concept{assertion}
\keyword{assertion}
