% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{get_imputation_target_time}
\alias{get_imputation_target_time}
\title{Get Time Imputation Targets}
\usage{
get_imputation_target_time(time_imputation)
}
\arguments{
\item{time_imputation}{The value to impute the time when a timepart is
missing.

A character value is expected, either as a
\itemize{
\item format with hour, min and sec specified as \code{"hh:mm:ss"}: e.g. \code{"00:00:00"}
for the start of the day,
\item or as a keyword: \code{"first"},\code{"last"} to impute to the start/end of a day.
}

\describe{
\item{Default value}{none}
}}
}
\value{
A list of character vectors. The elements of the list are named
"hour", "minute", "second".
}
\description{
Get Time Imputation Targets
}
\details{
\itemize{
\item For \code{time_imputation = "first"} \code{"00"}, \code{"00"}, \code{"00"} are returned.
\item For \code{time_imputation = "last"} \code{"23"}, \code{"59"}, \code{"59"} are returned.
\item For \code{time_imputation = "<hh>:<mm>:<ss>"} \code{"<hh>"}, \code{"<mm>"}, \code{"<ss>"} are returned.
}
}
\examples{
# Get imputation target for "first" time
target_first_time <- admiral:::get_imputation_target_time("first")
print(target_first_time)

# Get imputation target for "last" time
target_last_time <- admiral:::get_imputation_target_time("last")
print(target_last_time)

# Get imputation target for custom time imputation "12-34-56"
target_custom_time <- admiral:::get_imputation_target_time("12-34-56")
print(target_custom_time)

}
\seealso{
\code{\link[=impute_dtc_dtm]{impute_dtc_dtm()}}

Utilities used for date imputation: 
\code{\link{dt_level}()},
\code{\link{dtm_level}()},
\code{\link{get_imputation_target_date}()},
\code{\link{get_partialdatetime}()},
\code{\link{restrict_imputed_dtc_dt}()},
\code{\link{restrict_imputed_dtc_dtm}()}
}
\concept{utils_impute}
\keyword{internal}
