% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_locf_records.R
\name{derive_locf_records}
\alias{derive_locf_records}
\title{Derive LOCF (Last Observation Carried Forward) Records}
\usage{
derive_locf_records(
  dataset,
  dataset_ref,
  by_vars,
  id_vars_ref = NULL,
  analysis_var = AVAL,
  imputation = "add",
  order,
  keep_vars = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars}, \code{analysis_var}, \code{order}, and \code{keep_vars} arguments are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{dataset_ref}{Expected observations dataset

Data frame with all the combinations of \code{PARAMCD}, \code{PARAM}, \code{AVISIT},
\code{AVISITN}, ... which are expected in the dataset is expected.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

For each group defined by \code{by_vars} those observations from \code{dataset_ref}
are added to the output dataset which do not have a corresponding observation
in the input dataset or for which \code{analysis_var} is \code{NA} for the corresponding observation
in the input dataset.

\describe{
\item{Default value}{none}
}}

\item{id_vars_ref}{Grouping variables in expected observations dataset

The variables to group by in \code{dataset_ref} when determining which observations should be
added to the input dataset.

\describe{
\item{Default value}{All the variables in \code{dataset_ref}}
}}

\item{analysis_var}{Analysis variable.

\describe{
\item{Permitted values}{a variable}
\item{Default value}{\code{AVAL}}
}}

\item{imputation}{Select the mode of imputation:

\code{add}: Keep all original records and add imputed records for missing
timepoints and missing \code{analysis_var} values from \code{dataset_ref}.

\code{update}: Update records with missing \code{analysis_var} and add imputed records
for missing timepoints from \code{dataset_ref}.

\code{update_add}: Keep all original records, update records with missing \code{analysis_var}
and add imputed records for missing timepoints from \code{dataset_ref}.

\describe{
\item{Permitted values}{One of these 3 values: \code{"add"}, \code{"update"}, \code{"update_add"}}
\item{Default value}{\code{"add"}}
}}

\item{order}{Sort order

The dataset is sorted by \code{order} before carrying the last observation
forward (e.g. \code{AVAL}) within each \code{by_vars}.

For handling of \code{NA}s in sorting variables see \href{../articles/generic.html#sort_order}{Sort Order}.

\describe{
\item{Default value}{none}
}}

\item{keep_vars}{Variables that need carrying the last observation forward

Keep variables that need carrying the last observation forward other than \code{analysis_var}
(e.g., \code{PARAMN}, \code{VISITNUM}). If by default \code{NULL}, only variables specified in
\code{by_vars} and \code{analysis_var} will be populated in the newly created records.

\describe{
\item{Default value}{\code{NULL}}
}}
}
\value{
The input dataset with the new "LOCF" observations added for each
\code{by_vars}, based on the value passed to the \code{imputation} argument.
}
\description{
Adds LOCF records as new observations for each 'by group' when the dataset
does not contain observations for missed visits/time points and when analysis
value is missing.
}
\details{
For each group (with respect to the variables specified for the
by_vars parameter) those observations from \code{dataset_ref} are added to
the output dataset
\itemize{
\item which do not have a corresponding observation in the input dataset or
\item for which \code{analysis_var} is \code{NA} for the corresponding observation in the input dataset.

For the new observations, \code{analysis_var} is set to the non-missing \code{analysis_var} of the
previous observation in the input dataset (when sorted by \code{order}) and
\code{DTYPE} is set to "LOCF".

The \code{imputation} argument decides whether to update the existing observation when
\code{analysis_var} is \code{NA} (\code{"update"} and \code{"update_add"}), or to add a new observation from
\code{dataset_ref} instead (\code{"add"}).
}
}
\examples{

library(dplyr)
library(tibble)

advs <- tribble(
  ~STUDYID,  ~USUBJID,      ~VSSEQ, ~PARAMCD, ~PARAMN, ~AVAL, ~AVISITN, ~AVISIT,
  "CDISC01", "01-701-1015",      1, "PULSE",        1,    65,        0, "BASELINE",
  "CDISC01", "01-701-1015",      2, "DIABP",        2,    79,        0, "BASELINE",
  "CDISC01", "01-701-1015",      3, "DIABP",        2,    80,        2, "WEEK 2",
  "CDISC01", "01-701-1015",      4, "DIABP",        2,    NA,        4, "WEEK 4",
  "CDISC01", "01-701-1015",      5, "DIABP",        2,    NA,        6, "WEEK 6",
  "CDISC01", "01-701-1015",      6, "SYSBP",        3,   130,        0, "BASELINE",
  "CDISC01", "01-701-1015",      7, "SYSBP",        3,   132,        2, "WEEK 2"
)

# A dataset with all the combinations of PARAMCD, PARAM, AVISIT, AVISITN, ...
# which are expected.
advs_expected_obsv <- tribble(
  ~PARAMCD, ~AVISITN, ~AVISIT,
  "PULSE",         0, "BASELINE",
  "PULSE",         6, "WEEK 6",
  "DIABP",         0, "BASELINE",
  "DIABP",         2, "WEEK 2",
  "DIABP",         4, "WEEK 4",
  "DIABP",         6, "WEEK 6",
  "SYSBP",         0, "BASELINE",
  "SYSBP",         2, "WEEK 2",
  "SYSBP",         4, "WEEK 4",
  "SYSBP",         6, "WEEK 6"
)

# Example 1: Add imputed records for missing timepoints and for missing
#            `analysis_var` values (from `dataset_ref`), keeping all the original records.
derive_locf_records(
  dataset = advs,
  dataset_ref = advs_expected_obsv,
  by_vars = exprs(STUDYID, USUBJID, PARAMCD),
  imputation = "add",
  order = exprs(AVISITN, AVISIT),
  keep_vars = exprs(PARAMN)
) |>
  arrange(USUBJID, PARAMCD, AVISIT)


# Example 2: Add imputed records for missing timepoints (from `dataset_ref`)
#            and update missing `analysis_var` values.
derive_locf_records(
  dataset = advs,
  dataset_ref = advs_expected_obsv,
  by_vars = exprs(STUDYID, USUBJID, PARAMCD),
  imputation = "update",
  order = exprs(AVISITN, AVISIT),
) |>
  arrange(USUBJID, PARAMCD, AVISIT)


# Example 3: Add imputed records for missing timepoints (from `dataset_ref`) and
#            update missing `analysis_var` values, keeping all the original records.
derive_locf_records(
  dataset = advs,
  dataset_ref = advs_expected_obsv,
  by_vars = exprs(STUDYID, USUBJID, PARAMCD),
  imputation = "update_add",
  order = exprs(AVISITN, AVISIT),
) |>
  arrange(USUBJID, PARAMCD, AVISIT)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\author{
G Gayatri
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
