% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admiral_options.R
\name{get_admiral_option}
\alias{get_admiral_option}
\title{Get the Value of an Admiral Option}
\usage{
get_admiral_option(option)
}
\arguments{
\item{option}{A character scalar of commonly used admiral function inputs.

As of now, support only available for "subject_keys".
See \code{set_admiral_options()} for a description of the options.}
}
\value{
The value of the specified option.
}
\description{
Get the Value of an Admiral Option Which Can Be Modified for Advanced Users.
}
\details{
This function allows flexibility for function inputs that may need to be repeated
multiple times in a script, such as \code{subject_keys}.
}
\examples{
library(admiral.test)
library(dplyr, warn.conflicts = FALSE)
data("admiral_vs")
data("admiral_dm")

# Merging all dm variables to vs
derive_vars_merged(
  admiral_vs,
  dataset_add = select(admiral_dm, -DOMAIN),
  by_vars = get_admiral_option("subject_keys")
) \%>\%
  select(STUDYID, USUBJID, VSTESTCD, VISIT, VSTPT, VSSTRESN, AGE, AGEU)
}
\seealso{
\code{\link[=vars]{vars()}}, \code{\link[=set_admiral_options]{set_admiral_options()}}, \code{\link[=derive_param_exist_flag]{derive_param_exist_flag()}},
\code{\link[=derive_param_first_event]{derive_param_first_event()}}, \code{\link[=derive_param_tte]{derive_param_tte()}}, \code{\link[=derive_var_disposition_status]{derive_var_disposition_status()}},
\code{\link[=derive_var_dthcaus]{derive_var_dthcaus()}}, \code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_vars_disposition_reason]{derive_vars_disposition_reason()}},
\code{\link[=derive_vars_period]{derive_vars_period()}}, \code{\link[=create_period_dataset]{create_period_dataset()}}

Other admiral_options: 
\code{\link{set_admiral_options}()}
}
\author{
Zelos Zhu
}
\concept{admiral_options}
\keyword{admiral_options}
