% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_exposure.R
\name{derive_param_exposure}
\alias{derive_param_exposure}
\title{Add an Aggregated Parameter and Derive the Associated Start and End Dates}
\usage{
derive_param_exposure(
  dataset,
  by_vars,
  input_code,
  analysis_var,
  summary_fun,
  filter = NULL,
  set_values_to = NULL
)
}
\arguments{
\item{dataset}{Input dataset
\itemize{
\item The variables specified by the \code{by_vars},\code{analysis_var} parameters and \code{PARAMCD} are
expected,
\item Either \code{ASTDTM} and \code{AENDTM} or \code{ASTDT} and \code{AENDT} are also expected.
}}

\item{by_vars}{Grouping variables

For each group defined by \code{by_vars} an observation is added to the output
dataset.

\emph{Permitted Values:} list of variables}

\item{input_code}{Required parameter code

The observations where \code{PARAMCD} equals the specified value are considered to compute the
summary record.

\emph{Permitted Values:} A character of \code{PARAMCD} value}

\item{analysis_var}{Analysis variable.}

\item{summary_fun}{Function that takes as an input the \code{analysis_var} and
performs the calculation.
This can include built-in functions as well as user defined functions,
for example \code{mean} or \code{function(x) mean(x, na.rm = TRUE)}.}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\emph{Permitted Values:} a condition}

\item{set_values_to}{Variable-value pairs

Set a list of variables to some specified value for the new observation(s)
\itemize{
\item LHS refer to a variable. It is expected that at least \code{PARAMCD} is defined.
\item RHS refers to the values to set to the variable. This can be a string, a symbol, a numeric
value or NA.
(e.g.  \code{vars(PARAMCD = "TDOSE",PARCAT1 = "OVERALL")}).
More general expression are not allowed.
}

\emph{Permitted Values:} List of variable-value pairs}
}
\value{
The input dataset with a new record added for each group (with respect to the variables
specified for the \code{by_vars} parameter).
For each new record,
\itemize{
\item the variable specified \code{analysis_var} is computed as defined by \code{summary_fun},
\item the variable(s) specified on the LHS of \code{set_values_to} are set to their paired value (RHS).
In addition, the start and end date are computed as the minimum/maximum dates by \code{by_vars}.
}

If the input datasets contains
\itemize{
\item both \code{AxxDTM} and \code{AxxDT} then all \code{ASTDTM},\code{AENDTM}, \code{ASTDT}, \code{AENDT} are computed
\item only \code{AxxDTM} then \code{ASTDTM},\code{AENDTM} are computed
\item only \code{AxxDT} then \code{ASTDT},\code{AENDT} are computed.
}
}
\description{
Add a record computed from the aggregated analysis value of another parameter and compute the
start (\code{ASTDT(M)})and end date (\code{AENDT(M)}) as the minimum and maximum date by \code{by_vars}.
}
\details{
For each group (with respect to the variables specified for the \code{by_vars} parameter),
an observation is added to the output dataset and the defined values are set to the defined
variables
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(lubridate, warn.conflicts = FALSE)
library(stringr, warn.conflicts = FALSE)
adex <- tibble::tribble(
  ~USUBJID, ~PARAMCD, ~AVAL, ~AVALC, ~VISIT, ~ASTDT, ~AENDT,
  "1015", "DOSE", 80, NA_character_, "BASELINE", ymd("2014-01-02"), ymd("2014-01-16"),
  "1015", "DOSE", 85, NA_character_, "WEEK 2", ymd("2014-01-17"), ymd("2014-06-18"),
  "1015", "DOSE", 82, NA_character_, "WEEK 24", ymd("2014-06-19"), ymd("2014-07-02"),
  "1015", "ADJ", NA, NA_character_, "BASELINE", ymd("2014-01-02"), ymd("2014-01-16"),
  "1015", "ADJ", NA, NA_character_, "WEEK 2", ymd("2014-01-17"), ymd("2014-06-18"),
  "1015", "ADJ", NA, NA_character_, "WEEK 24", ymd("2014-06-19"), ymd("2014-07-02"),
  "1017", "DOSE", 80, NA_character_, "BASELINE", ymd("2014-01-05"), ymd("2014-01-19"),
  "1017", "DOSE", 50, NA_character_, "WEEK 2", ymd("2014-01-20"), ymd("2014-05-10"),
  "1017", "DOSE", 65, NA_character_, "WEEK 24", ymd("2014-05-10"), ymd("2014-07-02"),
  "1017", "ADJ", NA, NA_character_, "BASELINE", ymd("2014-01-05"), ymd("2014-01-19"),
  "1017", "ADJ", NA, "ADVERSE EVENT", "WEEK 2", ymd("2014-01-20"), ymd("2014-05-10"),
  "1017", "ADJ", NA, NA_character_, "WEEK 24", ymd("2014-05-10"), ymd("2014-07-02")
) \%>\%
  mutate(ASTDTM = ymd_hms(paste(ASTDT, "00:00:00")), AENDTM = ymd_hms(paste(AENDT, "00:00:00")))

# Cumulative dose
adex \%>\%
  derive_param_exposure(
    by_vars = vars(USUBJID),
    set_values_to = vars(PARAMCD = "TDOSE", PARCAT1 = "OVERALL"),
    input_code = "DOSE",
    analysis_var = AVAL,
    summary_fun = function(x) sum(x, na.rm = TRUE)
   ) \%>\%
  select(-ASTDTM, -AENDTM)

# average dose in w2-24
adex \%>\%
  derive_param_exposure(
    by_vars = vars(USUBJID),
    filter = VISIT \%in\% c("WEEK 2", "WEEK 24"),
    set_values_to = vars(PARAMCD = "AVDW224", PARCAT1 = "WEEK2-24"),
    input_code = "DOSE",
    analysis_var = AVAL,
    summary_fun = function(x) mean(x, na.rm = TRUE)
  ) \%>\%
  select(-ASTDTM, -AENDTM)

# Any dose adjustment?
adex \%>\%
  derive_param_exposure(
    by_vars = vars(USUBJID),
    set_values_to = vars(PARAMCD = "TADJ", PARCAT1 = "OVERALL"),
    input_code = "ADJ",
    analysis_var = AVALC,
    summary_fun = function(x) if_else(sum(!is.na(x)) > 0, "Y", NA_character_)
  ) \%>\%
  select(-ASTDTM, -AENDTM)
}
\author{
Samia Kabi
}
\keyword{adex}
\keyword{bds}
\keyword{derivation}
