% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_disposition_reason.R
\name{derive_disposition_reason}
\alias{derive_disposition_reason}
\title{Derive a Disposition Reason at a Specific Timepoint}
\usage{
derive_disposition_reason(
  dataset,
  dataset_ds,
  new_var,
  reason_var,
  new_var_spe = NULL,
  reason_var_spe = NULL,
  format_new_vars = format_reason_default,
  filter_ds,
  subject_keys = vars(STUDYID, USUBJID)
)
}
\arguments{
\item{dataset}{Input dataset.}

\item{dataset_ds}{Dataset containing the disposition information (e.g.: \code{ds}).

It must contain:
\itemize{
\item \code{STUDYID}, \code{USUBJID},
\item The variable(s) specified in the \code{reason_var} (and \code{reason_var_spe}, if required)
\item The variables used in \code{filter_ds}.
}}

\item{new_var}{Name of the disposition reason variable.

A variable name is expected (e.g. \code{DCSREAS}).}

\item{reason_var}{The variable used to derive the disposition reason

A variable name is expected (e.g. \code{DSDECOD}).}

\item{new_var_spe}{Name of the disposition reason detail variable.

A variable name is expected (e.g. \code{DCSREASP}).
If \code{new_var_spe} is specified, it is expected that \code{reason_var_spe} is also specified,
otherwise an error is issued.

Default: NULL}

\item{reason_var_spe}{The variable used to derive the disposition reason detail

A variable name is expected (e.g. \code{DSTERM}).
If \code{new_var_spe} is specified, it is expected that \code{reason_var_spe} is also specified,
otherwise an error is issued.

Default: NULL}

\item{format_new_vars}{The function used to derive the reason(s)

This function is used to derive the disposition reason(s) and must follow the below conventions
\itemize{
\item If only the main reason for discontinuation needs to be derived (i.e. \code{new_var_spe} is NULL),
the function must have at least one character vector argument, e.g.
\verb{format_reason <- function(reason)}
and \code{new_var} will be derived as \code{new_var = format_reason(reason_var)}
Typically, the content of the function would return \code{reason_var} or \code{NA} depending on the
value (e.g. \code{if_else ( reason != "COMPLETED" & !is.na(reason), reason, NA_character_)}).
\code{DCSREAS = format_reason(DSDECOD)} returns DCSREAS = \code{DSDECOD} when \code{DSDECOD} is not 'COMPLETED'
nor \code{NA}, \code{NA} otherwise.
\item If both the main reason and the details needs to be derived (\code{new_var_spe} is specified)
the function must have two character vectors argument, e.g.
\verb{format_reason2 <- function(reason, reason_spe)} and
\code{new_var} will be derived as \code{new_var} = \code{format_reason(reason_var)},
\code{new_var_spe} will be derived as \code{new_var_spe} = \code{format_reason(reason_var, reason_var_spe)},
Typically, the content of the function would return \code{reason_var_spe} or \code{NA} depending on the
\code{reason_var} value (e.g. \code{if_else ( reason != "COMPLETED" & !is.na(reason), reason_spe, NA_character_)}).
\code{DCSREASP = format_reason(DSDECOD, DSTERM)} returns DCSREASP = \code{DSTERM} when \code{DSDECOD} is not
'COMPLETED' nor NA.
}

Default: format_reason_default defined as:
format_reason_default <- function(reason, reason_spe = NULL) {
out <- if ( is.null(reason_spe) ) reason else reason_spe
if_else ( reason != "COMPLETED" & !is.na(reason), out, NA_character_)
}
format_reason_default(DSDECOD) returns \code{DSDECOD} when \code{DSDECOD} is not 'COMPLETED' nor NA.
format_reason_default(DSDECOD, DSTERM) returns \code{DSTERM} when \code{DSDECOD} is not 'COMPLETED' nor NA.}

\item{filter_ds}{Filter condition for the disposition data.

Filter used to select the relevant disposition data.
It is expected that the filter restricts \code{dataset_ds} such that there is at most
one observation per patient. An error is issued otherwise.

Permitted Values: logical expression.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of quosures where the expressions are symbols as returned by
\code{vars()} is expected.}
}
\value{
the input dataset with the disposition reason(s) (\code{new_var} and
if required \code{new_var_spe}) added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\emph{Deprecated}, please use \code{derive_vars_disposition_reason()} instead.

Derive a disposition reason from the the relevant records in the disposition domain.
}
\details{
This functions returns the main reason for discontinuation (e.g. \code{DCSREAS} or \code{DCTREAS}).
The reason for discontinuation is derived based on \code{reason_var} (e.g. \code{DSDECOD}) and
\code{format_new_vars}.
If \code{new_var_spe} is not NULL, then the function will also return the details associated
with the reason for discontinuation (e.g. \code{DCSREASP}).
The details associated with the reason for discontinuation are derived based on
\code{reason_var_spe} (e.g. \code{DSTERM}), \code{reason_var} and \code{format_new_vars}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("dm")
data("ds")

# Derive DCSREAS using the default format
dm \%>\%
  derive_disposition_reason(
    dataset_ds = ds,
    new_var = DCSREAS,
    reason_var = DSDECOD,
    filter_ds = DSCAT == "DISPOSITION EVENT"
  ) \%>\%
  select(STUDYID, USUBJID, DCSREAS)

# Derive DCSREAS and DCSREASP using a study-specific format
format_dcsreas <- function(x, y = NULL) {
  out <- if (is.null(y)) x else y
  case_when(
    !(x \%in\% c("COMPLETED", "SCREEN FAILURE")) & !is.na(x) ~ out,
    TRUE ~ NA_character_
  )
}
dm \%>\%
  derive_disposition_reason(
    dataset_ds = ds,
    new_var = DCSREAS,
    reason_var = DSDECOD,
    new_var_spe = DCSREASP,
    reason_var_spe = DSTERM,
    format_new_vars = format_dcsreas,
    filter_ds = DSCAT == "DISPOSITION EVENT"
  ) \%>\%
  select(STUDYID, USUBJID, DCSREAS, DCSREASP)
}
\seealso{
\code{\link[=format_reason_default]{format_reason_default()}}
}
\author{
Samia Kabi
}
\keyword{adsl}
