% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_s3_class}
\alias{assert_s3_class}
\title{Is an Argument an Object of a Specific S3 Class?}
\usage{
assert_s3_class(arg, class, optional = TRUE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{class}{The S3 class to check for}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is an object which does \emph{not} inherit from \code{class}.
Otherwise, the input is returned invisibly.
}
\description{
Checks if an argument is an object inheriting from the S3 class specified.
}
\examples{
example_fun <- function(obj) {
  assert_s3_class(obj, "factor")
}

example_fun(as.factor(letters))

try(example_fun(letters))

try(example_fun(1:10))
}
\author{
Thomas Neitmann
}
\keyword{assertion}
