% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_transposed.R
\name{derive_vars_atc}
\alias{derive_vars_atc}
\title{Derive ATC Class Variables}
\usage{
derive_vars_atc(
  dataset,
  dataset_facm,
  by_vars = exprs(USUBJID, CMREFID = FAREFID),
  value_var = FASTRESC
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} parameter are required}

\item{dataset_facm}{FACM dataset

The variables specified by the \code{by_vars} and \code{value_var} parameters,
\code{FAGRPID} and \code{FATESTCD} are required}

\item{by_vars}{Keys used to merge \code{dataset_facm} with \code{dataset}

\emph{Permitted Values:} list of variables}

\item{value_var}{The variable of \code{dataset_facm} containing the values of the
transposed variables

Default: \code{FASTRESC}}
}
\value{
The input dataset with ATC variables added
}
\description{
Add Anatomical Therapeutic Chemical class variables from \code{FACM} to \code{ADCM}
}
\examples{
library(tibble)

cm <- tribble(
  ~USUBJID, ~CMGRPID, ~CMREFID, ~CMDECOD,
  "BP40257-1001", "14", "1192056", "PARACETAMOL",
  "BP40257-1001", "18", "2007001", "SOLUMEDROL",
  "BP40257-1002", "19", "2791596", "SPIRONOLACTONE"
)
facm <- tribble(
  ~USUBJID, ~FAGRPID, ~FAREFID, ~FATESTCD, ~FASTRESC,
  "BP40257-1001", "1", "1192056", "CMATC1CD", "N",
  "BP40257-1001", "1", "1192056", "CMATC2CD", "N02",
  "BP40257-1001", "1", "1192056", "CMATC3CD", "N02B",
  "BP40257-1001", "1", "1192056", "CMATC4CD", "N02BE",
  "BP40257-1001", "1", "2007001", "CMATC1CD", "D",
  "BP40257-1001", "1", "2007001", "CMATC2CD", "D10",
  "BP40257-1001", "1", "2007001", "CMATC3CD", "D10A",
  "BP40257-1001", "1", "2007001", "CMATC4CD", "D10AA",
  "BP40257-1001", "2", "2007001", "CMATC1CD", "D",
  "BP40257-1001", "2", "2007001", "CMATC2CD", "D07",
  "BP40257-1001", "2", "2007001", "CMATC3CD", "D07A",
  "BP40257-1001", "2", "2007001", "CMATC4CD", "D07AA",
  "BP40257-1001", "3", "2007001", "CMATC1CD", "H",
  "BP40257-1001", "3", "2007001", "CMATC2CD", "H02",
  "BP40257-1001", "3", "2007001", "CMATC3CD", "H02A",
  "BP40257-1001", "3", "2007001", "CMATC4CD", "H02AB",
  "BP40257-1002", "1", "2791596", "CMATC1CD", "C",
  "BP40257-1002", "1", "2791596", "CMATC2CD", "C03",
  "BP40257-1002", "1", "2791596", "CMATC3CD", "C03D",
  "BP40257-1002", "1", "2791596", "CMATC4CD", "C03DA"
)

derive_vars_atc(cm, facm)
}
\seealso{
OCCDS Functions: 
\code{\link{derive_var_trtemfl}()},
\code{\link{derive_vars_query}()},
\code{\link{get_terms_from_db}()}
}
\concept{der_occds}
\keyword{der_occds}
