raw2xyzmat <- function(obj){
#
#  values adapted from 
#   dcraw.c -- Dave Coffin's raw photo decoder
#   Copyright 1997-2007 by Dave Coffin, dcoffin a cybercom o net
#   http://cybercom.net/~dcoffin/dcraw/
#
    cam <- extract.info(obj,"Camera")
    mat <- switch(cam,
    "Apple QuickTake"=c(17576,-3191,-3318,5210,6733,-1942,9031,1280,-124),
    "Canon EOS D2000"=c(24542,-10860,-3401,-1490,11370,-297,2858,-605,3225),
    "Canon EOS D6000"=c( 20482,-7172,-3125,-1033,10410,-285,2542,226,3136 ),
    "Canon EOS D30"=c( 9805,-2689,-1312,-5803,13064,3068,-2438,3075,8775 ),
    "Canon EOS D60"=c( 6188,-1341,-890,-7168,14489,2937,-2640,3228,8483 ),
    "Canon EOS 5D"=c( 6347,-479,-972,-8297,15954,2480,-1968,2131,7649 ),
    "Canon EOS 20Da"=c( 14155,-5065,-1382,-6550,14633,2039,-1623,1824,6561 ),
    "Canon EOS 20D"=c( 6599,-537,-891,-8071,15783,2424,-1983,2234,7462 ),
    "Canon EOS 30D"=c( 6257,-303,-1000,-7880,15621,2396,-1714,1904,7046 ),
    "Canon EOS 350D"=c( 6018,-617,-965,-8645,15881,2975,-1530,1719,7642 ),
    "Canon EOS 300D"=c( 6018,-617,-965,-8645,15881,2975,-1530,1719,7642 ),
    "Canon EOS 300D DIGITAL"=c( 6018,-617,-965,-8645,15881,2975,-1530,1719,7642 ),
    "Canon EOS 400D"=c( 7054,-1501,-990,-8156,15544,2812,-1278,1414,7796 ),
    "Canon EOS-1Ds Mark II"=c( 6517,-602,-867,-8180,15926,2378,-1618,1771,7633 ),
    "Canon EOS-1D Mark II N"=c( 6240,-466,-822,-8180,15825,2500,-1801,1938,8042 ),
    "Canon EOS-1D Mark III"=c( 6291,-540,-976,-8350,16145,2311,-1714,1858,7326 ),
    "Canon EOS-1D Mark II"=c( 6264,-582,-724,-8312,15948,2504,-1744,1919,8664 ),
    "Canon EOS-1DS"=c( 4374,3631,-1743,-7520,15212,2472,-2892,3632,8161 ),
    "Canon EOS-1D"=c( 6806,-179,-1020,-8097,16415,1687,-3267,4236,7690 ),
    "Canon EOS"=c( 8197,-2000,-1118,-6714,14335,2592,-2536,3178,8266 ),
    "Canon PowerShot A50"=c( -5300,9846,1776,3436,684,3939,-5540,9879,6200,-1404,11175,217 ),
    "Canon PowerShot A5"=c( -4801,9475,1952,2926,1611,4094,-5259,10164,5947,-1554,10883,547 ),
    "Canon PowerShot G1"=c( -4778,9467,2172,4743,-1141,4344,-5146,9908,6077,-1566,11051,557 ),
    "Canon PowerShot G2"=c( 9087,-2693,-1049,-6715,14382,2537,-2291,2819,7790 ),
    "Canon PowerShot G3"=c( 9212,-2781,-1073,-6573,14189,2605,-2300,2844,7664 ),
    "Canon PowerShot G5"=c( 9757,-2872,-933,-5972,13861,2301,-1622,2328,7212 ),
    "Canon PowerShot G6"=c( 9877,-3775,-871,-7613,14807,3072,-1448,1305,7485 ),
    "Canon PowerShot Pro1"=c( 10062,-3522,-999,-7643,15117,2730,-765,817,7323 ),
    "Canon PowerShot Pro70"=c( -4155,9818,1529,3939,-25,4522,-5521,9870,6610,-2238,10873,1342 ),
    "Canon PowerShot Pro90"=c( -4963,9896,2235,4642,-987,4294,-5162,10011,5859,-1770,11230,577 ),
    "Canon PowerShot S30"=c( 10566,-3652,-1129,-6552,14662,2006,-2197,2581,7670 ),
    "Canon PowerShot S40"=c( 8510,-2487,-940,-6869,14231,2900,-2318,2829,9013 ),
    "Canon PowerShot S45"=c( 8163,-2333,-955,-6682,14174,2751,-2077,2597,8041 ),
    "Canon PowerShot S50"=c( 8882,-2571,-863,-6348,14234,2288,-1516,2172,6569 ),
    "Canon PowerShot S60"=c( 8795,-2482,-797,-7804,15403,2573,-1422,1996,7082 ),
    "Canon PowerShot S70"=c( 9976,-3810,-832,-7115,14463,2906,-901,989,7889 ),
    "Canon PowerShot A610"=c( 15591,-6402,-1592,-5365,13198,2168,-1300,1824,5075 ),
    "Canon PowerShot A620"=c( 15265,-6193,-1558,-4125,12116,2010,-888,1639,5220 ),
    "Canon PowerShot S3 IS"=c( 14062,-5199,-1446,-4712,12470,2243,-1286,2028,4836 ),
    "Contax N Digital"=c( 7777,1285,-1053,-9280,16543,2916,-3677,5679,7060 ),
    "EPSON R-D1"=c( 6827,-1878,-732,-8429,16012,2564,-704,592,7145 ),
    "FUJIFILM FinePix E550"=c( 11044,-3888,-1120,-7248,15168,2208,-1531,2277,8069 ),
    "FUJIFILM FinePix E900"=c( 9183,-2526,-1078,-7461,15071,2574,-2022,2440,8639 ),
    "FUJIFILM FinePix F8"=c( 11044,-3888,-1120,-7248,15168,2208,-1531,2277,8069 ),
    "FUJIFILM FinePix F7"=c( 10004,-3219,-1201,-7036,15047,2107,-1863,2565,7736 ),
    "FUJIFILM FinePix S20Pro"=c( 10004,-3219,-1201,-7036,15047,2107,-1863,2565,7736 ),
    "FUJIFILM FinePix S2Pro"=c( 12492,-4690,-1402,-7033,15423,1647,-1507,2111,7697 ),
    "FUJIFILM FinePix S3Pro"=c( 11807,-4612,-1294,-8927,16968,1988,-2120,2741,8006 ),
    "FUJIFILM FinePix S5Pro"=c( 12300,-5110,-1304,-9117,17143,1998,-1947,2448,8100 ),
    "FUJIFILM FinePix S5000"=c( 8754,-2732,-1019,-7204,15069,2276,-1702,2334,6982 ),
    "FUJIFILM FinePix S5100"=c( 11940,-4431,-1255,-6766,14428,2542,-993,1165,7421 ),
    "FUJIFILM FinePix S5500"=c( 11940,-4431,-1255,-6766,14428,2542,-993,1165,7421 ),
    "FUJIFILM FinePix S5200"=c( 9636,-2804,-988,-7442,15040,2589,-1803,2311,8621 ),
    "FUJIFILM FinePix S5600"=c( 9636,-2804,-988,-7442,15040,2589,-1803,2311,8621 ),
    "FUJIFILM FinePix S6"=c( 12628,-4887,-1401,-6861,14996,1962,-2198,2782,7091 ),
    "FUJIFILM FinePix S7000"=c( 10190,-3506,-1312,-7153,15051,2238,-2003,2399,7505 ),
    "FUJIFILM FinePix S9000"=c( 10491,-3423,-1145,-7385,15027,2538,-1809,2275,8692 ),
    "FUJIFILM FinePix S9500"=c( 10491,-3423,-1145,-7385,15027,2538,-1809,2275,8692 ),
    "FUJIFILM FinePix S9100"=c( 12343,-4515,-1285,-7165,14899,2435,-1895,2496,8800 ),
    "FUJIFILM FinePix S9600"=c( 12343,-4515,-1285,-7165,14899,2435,-1895,2496,8800 ),
    "Imacon Ixpress"=c( 7025,-1415,-704,-5188,13765,1424,-1248,2742,6038 ),
    "KODAK NC2000"=c( 16475,-6903,-1218,-851,10375,477,2505,-7,1020 ),
    "Kodak DCS315C"=c( 17523,-4827,-2510,756,8546,-137,6113,1649,2250 ),
    "Kodak DCS330C"=c( 20620,-7572,-2801,-103,10073,-396,3551,-233,2220 ),
    "KODAK DCS420"=c( 10868,-1852,-644,-1537,11083,484,2343,628,2216 ),
    "KODAK DCS460"=c( 10592,-2206,-967,-1944,11685,230,2206,670,1273 ),
    "KODAK EOSDCS1"=c( 10592,-2206,-967,-1944,11685,230,2206,670,1273 ),
    "KODAK EOSDCS3B"=c( 9898,-2700,-940,-2478,12219,206,1985,634,1031 ),
    "Kodak DCS520C"=c( 24542,-10860,-3401,-1490,11370,-297,2858,-605,3225 ),
    "Kodak DCS560C"=c( 20482,-7172,-3125,-1033,10410,-285,2542,226,3136 ),
    "Kodak DCS620C"=c( 23617,-10175,-3149,-2054,11749,-272,2586,-489,3453 ),
    "Kodak DCS620X"=c( 13095,-6231,154,12221,-21,-2137,895,4602,2258 ),
    "Kodak DCS660C"=c( 18244,-6351,-2739,-791,11193,-521,3711,-129,2802 ),
    "Kodak DCS720X"=c( 11775,-5884,950,9556,1846,-1286,-1019,6221,2728 ),
    "Kodak DCS760C"=c( 16623,-6309,-1411,-4344,13923,323,2285,274,2926 ),
    "Kodak DCS Pro SLR"=c( 5494,2393,-232,-6427,13850,2846,-1876,3997,5445 ),
    "Kodak DCS Pro 14nx"=c( 5494,2393,-232,-6427,13850,2846,-1876,3997,5445 ),
    "Kodak DCS Pro 14"=c( 7791,3128,-776,-8588,16458,2039,-2455,4006,6198 ),
    "Kodak ProBack645"=c( 16414,-6060,-1470,-3555,13037,473,2545,122,4948 ),
    "Kodak ProBack"=c( 21179,-8316,-2918,-915,11019,-165,3477,-180,4210 ),
    "KODAK P712"=c( 9658,-3314,-823,-5163,12695,2768,-1342,1843,6044 ),
    "KODAK P850"=c( 10511,-3836,-1102,-6946,14587,2558,-1481,1792,6246 ),
    "KODAK P880"=c( 12805,-4662,-1376,-7480,15267,2360,-1626,2194,7904 ),
    "Leaf CMost"=c( 3952,2189,449,-6701,14585,2275,-4536,7349,6536 ),
    "Leaf Valeo 6"=c( 3952,2189,449,-6701,14585,2275,-4536,7349,6536 ),
    "Leaf Aptus 65"=c( 7914,1414,-1190,-8777,16582,2280,-2811,4605,5562 ),
    "Leaf Aptus 75"=c( 7914,1414,-1190,-8777,16582,2280,-2811,4605,5562 ),
    "Leaf"=c( 8236,1746,-1314,-8251,15953,2428,-3673,5786,5771 ),
    "Mamiya ZD"=c( 7645,2579,-1363,-8689,16717,2015,-3712,5941,5961 ),
    "Micron 2010"=c( 16695,-3761,-2151,155,9682,163,3433,951,4904 ),
    "Minolta DiMAGE 5"=c( 8983,-2942,-963,-6556,14476,2237,-2426,2887,8014 ),
    "Minolta DiMAGE 7Hi"=c( 11368,-3894,-1242,-6521,14358,2339,-2475,3056,7285 ),
    "Minolta DiMAGE 7"=c( 9144,-2777,-998,-6676,14556,2281,-2470,3019,7744 ),
    "Minolta DiMAGE A1"=c( 9274,-2547,-1167,-8220,16323,1943,-2273,2720,8340 ),
    "MINOLTA DiMAGE A200"=c( 8560,-2487,-986,-8112,15535,2771,-1209,1324,7743 ),
    "Minolta DiMAGE A2"=c( 9097,-2726,-1053,-8073,15506,2762,-966,981,7763 ),
    "Minolta DiMAGE Z2"=c( 11280,-3564,-1370,-4655,12374,2282,-1423,2168,5396 ),
    "MINOLTA DYNAX 5"=c( 10284,-3283,-1086,-7957,15762,2316,-829,882,6644 ),
    "MINOLTA DYNAX 7"=c( 10239,-3104,-1099,-8037,15727,2451,-927,925,6871 ),
    "NIKON D100"=c( 5902,-933,-782,-8983,16719,2354,-1402,1455,6464 ),
    "NIKON D1H"=c( 7577,-2166,-926,-7454,15592,1934,-2377,2808,8606 ),
    "NIKON D1X"=c( 7702,-2245,-975,-9114,17242,1875,-2679,3055,8521 ),
    "NIKON D1"=c( 16772,-4726,-2141,-7611,15713,1972,-2846,3494,9521 ),
    "NIKON D2H"=c( 5710,-901,-615,-8594,16617,2024,-2975,4120,6830 ),
    "NIKON D2X"=c( 10231,-2769,-1255,-8301,15900,2552,-797,680,7148 ),
    "NIKON D40X"=c( 8819,-2543,-911,-9025,16928,2151,-1329,1213,8449 ),
    "NIKON D40"=c( 6992,-1668,-806,-8138,15748,2543,-874,850,7897 ),
    "NIKON D50"=c( 7732,-2422,-789,-8238,15884,2498,-859,783,7330 ),
    "NIKON D70"=c( 7732,-2422,-789,-8238,15884,2498,-859,783,7330 ),
    "NIKON D80"=c( 8629,-2410,-883,-9055,16940,2171,-1490,1363,8520 ),
    "NIKON D200"=c( 8367,-2248,-763,-8758,16447,2422,-1527,1550,8053 ),
    "NIKON E950"=c( -3746,10611,1665,9621,-1734,2114,-2389,7082,3064,3406,6116,-244 ),
    "NIKON E995"=c( -5547,11762,2189,5814,-558,3342,-4924,9840,5949,688,9083,96 ),
    "NIKON E2500"=c( -5547,11762,2189,5814,-558,3342,-4924,9840,5949,688,9083,96 ),
    "NIKON E4300"=c( 11280,-3564,-1370,-4655,12374,2282,-1423,2168,5396 ),
    "NIKON E4500"=c( -5547,11762,2189,5814,-558,3342,-4924,9840,5949,688,9083,96 ),
    "NIKON E5000"=c( -5547,11762,2189,5814,-558,3342,-4924,9840,5949,688,9083,96 ),
    "NIKON E5400"=c( 9349,-2987,-1001,-7919,15766,2266,-2098,2680,6839 ),
    "NIKON E5700"=c( -5368,11478,2368,5537,-113,3148,-4969,10021,5782,778,9028,211 ),
    "NIKON E8400"=c( 7842,-2320,-992,-8154,15718,2599,-1098,1342,7560 ),
    "NIKON E8700"=c( 8489,-2583,-1036,-8051,15583,2643,-1307,1407,7354 ),
    "NIKON E8800"=c( 7971,-2314,-913,-8451,15762,2894,-1442,1520,7610 ),
    "OLYMPUS C5050"=c( 10508,-3124,-1273,-6079,14294,1901,-1653,2306,6237 ),
    "OLYMPUS C5060"=c( 10445,-3362,-1307,-7662,15690,2058,-1135,1176,7602 ),
    "OLYMPUS C7070"=c( 10252,-3531,-1095,-7114,14850,2436,-1451,1723,6365 ),
    "OLYMPUS C70"=c( 10793,-3791,-1146,-7498,15177,2488,-1390,1577,7321 ),
    "OLYMPUS C80"=c( 8606,-2509,-1014,-8238,15714,2703,-942,979,7760 ),
    "OLYMPUS E-10"=c( 12745,-4500,-1416,-6062,14542,1580,-1934,2256,6603 ),
    "OLYMPUS E-1"=c( 11846,-4767,-945,-7027,15878,1089,-2699,4122,8311 ),
    "OLYMPUS E-20"=c( 13173,-4732,-1499,-5807,14036,1895,-2045,2452,7142 ),
    "OLYMPUS E-300"=c( 7828,-1761,-348,-5788,14071,1830,-2853,4518,6557 ),
    "OLYMPUS E-330"=c( 8961,-2473,-1084,-7979,15990,2067,-2319,3035,8249 ),
    "OLYMPUS E-400"=c( 6169,-1483,-21,-7107,14761,2536,-2904,3580,8568 ),
    "OLYMPUS E-410"=c( 8856,-2582,-1026,-7761,15766,2082,-2009,2575,7469 ),
    "OLYMPUS E-500"=c( 8136,-1968,-299,-5481,13742,1871,-2556,4205,6630 ),
    "OLYMPUS E-510"=c( 8856,-2582,-1026,-7761,15766,2082,-2009,2575,7469 ),
    "OLYMPUS SP350"=c( 12078,-4836,-1069,-6671,14306,2578,-786,939,7418 ),
    "OLYMPUS SP3"=c( 11766,-4445,-1067,-6901,14421,2707,-1029,1217,7572 ),
    "OLYMPUS SP500UZ"=c( 9493,-3415,-666,-5211,12334,3260,-1548,2262,6482 ),
    "OLYMPUS SP510UZ"=c( 10593,-3607,-1010,-5881,13127,3084,-1200,1805,6721 ),
    "OLYMPUS SP550UZ"=c( 11597,-4006,-1049,-5432,12799,2957,-1029,1750,6516 ),
    "PENTAX *ist DL2"=c( 10504,-2438,-1189,-8603,16207,2531,-1022,863,12242 ),
    "PENTAX *ist DL"=c( 10829,-2838,-1115,-8339,15817,2696,-837,680,11939 ),
    "PENTAX *ist DS2"=c( 10504,-2438,-1189,-8603,16207,2531,-1022,863,12242 ),
    "PENTAX *ist DS"=c( 10371,-2333,-1206,-8688,16231,2602,-1230,1116,11282 ),
    "PENTAX *ist D"=c( 9651,-2059,-1189,-8881,16512,2487,-1460,1345,10687 ),
    "PENTAX K10D"=c( 9566,-2863,-803,-7170,15172,2112,-818,803,9705 ),
    "PENTAX K1"=c( 11095,-3157,-1324,-8377,15834,2720,-1108,947,11688 ),
    "Panasonic DMC-FZ8"=c( 8986,-2755,-802,-6341,13575,3077,-1476,2144,6379 ),
    "Panasonic DMC-FZ30"=c( 10976,-4029,-1141,-7918,15491,2600,-1670,2071,8246 ),
    "Panasonic DMC-FZ50"=c( 7906,-2709,-594,-6231,13351,3220,-1922,2631,6537 ),
    "Panasonic DMC-L1"=c( 8054,-1885,-1025,-8349,16367,2040,-2805,3542,7629 ),
    "Panasonic DMC-LC1"=c( 11340,-4069,-1275,-7555,15266,2448,-2960,3426,7685 ),
    "Panasonic DMC-LX1"=c( 10704,-4187,-1230,-8314,15952,2501,-920,945,8927 ),
    "Panasonic DMC-LX2"=c( 8048,-2810,-623,-6450,13519,3272,-1700,2146,7049 ),
    "Phase One H 20"=c( 1313,1855,-109,-6715,15908,808,-327,1840,6020 ),
    "Phase One P 2"=c( 2905,732,-237,-8134,16626,1476,-3038,4253,7517 ),
    "Phase One P 30"=c( 4516,-245,-37,-7020,14976,2173,-3206,4671,7087 ),
    "Phase One P 45"=c( 5053,-24,-117,-5684,14076,1702,-2619,4492,5849 ),
    "SAMSUNG GX-1"=c( 10504,-2438,-1189,-8603,16207,2531,-1022,863,12242 ),
    "Sinar"=c( 16442,-2956,-2422,-2877,12128,750,-1136,6066,4559 ),
    "SONY DSC-F828"=c( 7924,-1910,-777,-8226,15459,2998,-1517,2199,6818,-7242,11401,3481 ),
    "SONY DSC-R1"=c( 8512,-2641,-694,-8042,15670,2526,-1821,2117,7414 ),
    "SONY DSC-V3"=c( 7511,-2571,-692,-7894,15088,3060,-948,1111,8128 ),
    "SONY DSLR-A100"=c(9437,-2811,-774,-8405,16215,2290,-710,596,7181),
     NULL)/10000
#
    if(is.null(mat)) {
        stop("Camera model obtained by extract.info(img,'Camera') unknown. Please check list in camera.R.")
    }
    if(length(mat)==9) dim(mat) <- c(3,3) else dim(mat) <- c(4,3)
#    svdmat <- svd(mat)
#    svdmat$v%*%diag(1/svdmat$d)%*%t(svdmat$u)
    mat
}