% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{format.adf_device}
\alias{format.adf_device}
\alias{format.adf_file_con}
\alias{format.adf_block}
\alias{format.virtual_path}
\alias{print.adf_device}
\alias{print.adf_file_con}
\alias{print.adf_block}
\alias{print.virtual_path}
\alias{as.character.virtual_path}
\title{Basic methods for S3 class objects}
\usage{
\method{format}{adf_device}(x, ...)

\method{format}{adf_file_con}(x, ...)

\method{format}{adf_block}(x, ...)

\method{format}{virtual_path}(x, width = 20L, ...)

\method{print}{adf_device}(x, ...)

\method{print}{adf_file_con}(x, ...)

\method{print}{adf_block}(x, ...)

\method{print}{virtual_path}(x, ...)

\method{as.character}{virtual_path}(x, ...)
}
\arguments{
\item{x}{Object to be formatted or printed}

\item{...}{Ignored or passed on to next methods}

\item{width}{Set the text width for formatting virtual paths}
}
\description{
Format and print methods for all S3 class objects created with \code{adfExplorer}
}
\examples{
my_device <- demo_adf()
vp        <- list_adf_entries(my_device, recursive = TRUE)
con       <- adf_file_con(my_device, "s/startup-sequence")
block     <- read_adf_block(my_device, 0L)

format(my_device)
format(vp)
format(con)
format(block)

print(my_device)
print(vp)
print(con)
print(block)

close(con)
close(my_device)
}
