% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{methods}
\name{is.bootable}
\alias{is.bootable}
\alias{is.bootable,amigaDisk-method}
\title{Check if amigaDisk object is bootable}
\usage{
\S4method{is.bootable}{amigaDisk}(x)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object for which
the check should be performed.}
}
\value{
Returns a \code{logical} value, indicating whether
the disk is bootable.
}
\description{
This function checks if the \code{\link{amigaDisk}}
object represents a bootable disk.
}
\details{
The first two \code{\linkS4class{amigaBlock}} objects on a disk
are special and are called the boot block. The boot block will
determine whether an Amiga can boot from the disk.

This function will determine whether the Amiga would attempt
to execute the machine code present on the boot block. It will not
check whether it would be successful at that, as that would
require emulation of the Commodore Amiga system.
}
\examples{
data(adf.example)

## let's check if the example amigaDisk object
## is bootable:

is.bootable(adf.example)

## it apparently is
}
\author{
Pepijn de Vries
}
