% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.convex_relu}
\alias{matrix.convex_relu}
\title{Creates a feature matrix for the convex relu problem.}
\usage{
matrix.convex_relu(mat, mask, gated = FALSE, n_threads = 1)
}
\arguments{
\item{mat}{Base feature matrix. It is either a dense or sparse matrix.}

\item{mask}{Boolean mask matrix.}

\item{gated}{Flag to indicate whether to use the convex gated relu feature matrix.}

\item{n_threads}{Number of threads.}
}
\value{
Convex relu feature matrix.
The object is an S4 class with methods for efficient computation in C++ by adelie.
}
\description{
Creates a feature matrix for the convex relu problem.
}
\examples{
n <- 100
p <- 20
m <- 10
Z_dense <- matrix(rnorm(n * p), n, p)
mask <- matrix(rbinom(n * m, 1, 0.5), n, m)
out <- matrix.convex_relu(Z_dense, mask)
Z_sparse <- as(Z_dense, "dgCMatrix")
out <- matrix.convex_relu(Z_sparse, mask)
}
\author{
Trevor Hastie and James Yang\cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
