% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.concatenate}
\alias{matrix.concatenate}
\title{Creates a concatenation of the matrices.}
\usage{
matrix.concatenate(mats, axis = 0, n_threads = 1)
}
\arguments{
\item{mats}{List of matrices.}

\item{axis}{The axis along which the matrices will be joined.}

\item{n_threads}{Number of threads.}
}
\value{
Concatenation of matrices.
}
\description{
Creates a concatenation of the matrices.
}
\examples{
n <- 100
ps <- c(10, 20, 30)
mats <- lapply(ps, function(p) { 
    matrix.dense(matrix(rnorm(n * p), n, p))
})
out <- matrix.concatenate(mats, axis=1)
ns <- c(10, 20, 30)
p <- 100
mats <- lapply(ns, function(n) { 
    matrix.dense(matrix(rnorm(n * p), n, p))
})
out <- matrix.concatenate(mats, axis=0)
}
