% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi_adea.R
\name{roi_adea}
\alias{roi_adea}
\title{Build adea problem}
\usage{
roi_adea(input, output, orientation, load.orientation, solver)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}

\item{load.orientation}{This parameter allows the selection of variables to be included in load analysis. 
The default is "inoutput" which means that all input and output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{solver}{Any of the available solver that will be used by ROI to solve the optimization problem. Use <code>ROI_installed_solvers()</code> to list them.}
}
\value{
list(lp, status, solver, ux, vy, eff, loads = list())
}
\description{
For the given input and output build the adea problem and return it.
}
\details{
Note: As this function is mainly for internal use, to avoid unnecessary overload, it does not do an extensive check of the input parameters. Use the higher level adea function instead.
}
\keyword{internal}
