% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{classificar_conta_dre}
\alias{classificar_conta_dre}
\title{Classifica contas específicas da Demonstração do Resultado do Exercício (DRE)}
\usage{
classificar_conta_dre(conta)
}
\arguments{
\item{conta}{Um vetor de caracteres contendo o nome da conta a ser classificada.}
}
\value{
Um vetor de caracteres indicando a categoria da DRE correspondente ao valor
        informado. Caso o nome não seja reconhecido entre as categorias mapeadas,
        retorna \code{NA}.
}
\description{
Esta função recebe o nome de uma conta e identifica sua categoria dentro das
classes previstas para a Demonstração do Resultado do Exercício. A classificação
é realizada com base na lista interna `categorias_dre`, que associa cada categoria
aos respectivos nomes de contas normalmente encontrados em demonstrações contábeis.
}
\details{
O objetivo principal é padronizar a identificação das contas, facilitando etapas
subsequentes de análise, agrupamento, sumarização e composição de indicadores.


A função realiza uma busca direta por correspondência exata entre o valor de
\code{conta} e os elementos registrados na lista `categorias_dre`. Assim,
recomenda-se que os nomes das contas sejam previamente normalizados, removendo
acentos, padronizando letras minúsculas e eliminando variações ortográficas,
a fim de maximizar a precisão da classificação.
}
\keyword{internal}
