% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{compileDetections}
\alias{compileDetections}
\title{Combine ALS detections}
\usage{
compileDetections(
  path = "detections",
  start.time = NULL,
  stop.time = NULL,
  tz,
  save.detections = FALSE,
  record.source = FALSE
)
}
\arguments{
\item{path}{the path(s) to the detection files}

\item{start.time}{Detection data prior to the timestamp set in
\code{start.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{stop.time}{Detection data posterior to the timestamp set in
\code{stop.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{tz}{The time zone of the study area. Must match one of the values
present in \code{\link[base]{timezones}}.}

\item{save.detections}{Logical: Should the processed detections be saved for
future runs?}
}
\value{
A data frame with all the detections
}
\description{
Finds the detections' files and processes them.
}
\keyword{internal}
