% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_cuts_printtranscript.R
\name{search_cuts_printtranscript}
\alias{search_cuts_printtranscript}
\title{Create print transcripts for all search results}
\usage{
search_cuts_printtranscript(x, s, l = NULL, outputFolder = NULL)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{l}{Layout object.}

\item{outputFolder}{Character string; if parameter is not set, the print transcripts will only be inserted in \code{s@results}; if the path to a existing folder is given transcripts will be saved in '.txt' format.}
}
\value{
Search object;
}
\description{
Subtitles in 'Subrib Title' .srt format will be created for each search result.
The subtitles will be inserted into the column defined in \code{s@cuts.column.printtranscript}.
All transcripts will be stored in \code{s@cuts.printtranscripts}.
}
\details{
\emph{Span} \cr
If you want to extend the cut before or after each search result, you can modify \code{@cuts.span.beforesec} and \code{@cuts.span.aftersec} in your search object.
If you want to modify the layout of the print transcripts, create a new layout object with \code{mylayout <- methods::new("layout")}, modify the settings and pass it as argument \code{l}.
}
\examples{
library(act)

# Search
mysearch <- act::search_new(examplecorpus, pattern="yo")

# Create print transcripts for all search results
test <- act::search_cuts_printtranscript (x=examplecorpus, s=mysearch)

# Display all print transcripts on screen from @cuts.printtranscripts
cat(test@cuts.printtranscripts)

# Display all print transcripts from results data frame
cat(test@results[,mysearch@cuts.column.printtranscript])
cat(stringr::str_c(test@results[,mysearch@cuts.column.printtranscript], sep="\n", collapse = "\n"))

# Only single print transcript from results data frame
cat(test@results[1,mysearch@cuts.column.printtranscript])

# Create print transcript snippets including 1 sec before and 5 sec after
mysearch@cuts.span.beforesec =1
mysearch@cuts.span.aftersec = 5
test <- act::search_cuts_printtranscript (x=examplecorpus,
s=mysearch)

# Display all transcript snippets on screen
cat(stringr::str_c(test@results[,mysearch@cuts.column.printtranscript], sep="\n", collapse = "\n"))
}
