% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_new.R
\name{search_new}
\alias{search_new}
\title{Create a new search}
\usage{
search_new(
  x,
  pattern,
  searchMode = "fulltext",
  searchNormalized = TRUE,
  filterTranscriptsInclude = NA,
  filterTranscriptsExclude = NA,
  filterTiersInclude = NA,
  filterTiersExclude = NA,
  startSec = NA,
  endSec = NA,
  makeConcordance = TRUE,
  prefix = "result",
  runSearch = TRUE,
  showProgress = TRUE,
  updateX = TRUE
)
}
\arguments{
\item{x}{Corpus object.}

\item{pattern}{Character string; search pattern as regular expression.}

\item{searchMode}{Character string; takes the following values: content, fulltext (=default, includes both fulltext modes ), fulltext.byTime, fulltext.byTier.}

\item{searchNormalized}{Logical; if \code{TRUE} function will search in the normalized content, if \code{FALSE} function will search in the original content.}

\item{filterTranscriptsInclude}{Character string; as regular expression, limit search to certain transcripts matching the expression.}

\item{filterTranscriptsExclude}{Character string; as regular expression, exclude certain transcripts matching the expression.}

\item{filterTiersInclude}{Character string; as regular expression, limit search to certain tiers matching the expression.}

\item{filterTiersExclude}{Character string; as regular expression, exclude certain tiers matching the expression.}

\item{startSec}{Double; start time of region for search.}

\item{endSec}{Double; end time of region for search.}

\item{makeConcordance}{Logical; if \code{TRUE} concordance will be added to search results.}

\item{prefix}{Character string; prefix for the name of the consecutively numbered search results.}

\item{runSearch}{Logical; if \code{TRUE} search will be run in corpus object, if \code{FALSE} only the search object will be created.}

\item{showProgress}{Logical; if \code{TRUE} progress bar will be shown.}

\item{updateX}{Logical; If \code{TRUE} the original corpus object passed as x to the function will also be updated! If you do not want this, set to \code{FALSE}.}
}
\value{
Search object.
}
\description{
Creates a new search object and runs the search in a corpus object.
Only 'x' and 'pattern' are obligatory. 
The other arguments can be left to their default values.
}
\examples{
library(act)

# Search for the 1. Person Singular Pronoun in Spanish.
mysearch <- act::search_new(examplecorpus, pattern= "yo")
mysearch
# Search in normalized content vs. original content
mysearch.norm  <- act::search_new(examplecorpus, pattern="yo", searchNormalized=TRUE)
mysearch.org   <- act::search_new(examplecorpus, pattern="yo", searchNormalized=FALSE)
mysearch.norm@results.nr
mysearch.org@results.nr

# The difference is because during normalization capital letters will be converted
# to small letters. One annotation in the example corpus contains a "yo" with a
# capital letter:
mysearch <- act::search_new(examplecorpus, pattern="yO", searchNormalized=FALSE)
mysearch@results$hit

# Search in full text vs. original content.
# Full text search will find matches across annotations.
# Let's define a regular expression with a certain span.
# Search for the word "no" 'no' followed by a "pero" 'but'
# in a distance ranging from 1 to 20 characters.
myRegEx <- "\\\\bno\\\\b.{1,20}pero"
mysearch <- act::search_new(examplecorpus, pattern=myRegEx, searchMode="fulltext")
mysearch
mysearch@results$hit

}
