% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praat.R
\name{praat_open_result}
\alias{praat_open_result}
\title{Open a search result in 'Praat'}
\usage{
praat_open_result(x, result)
}
\arguments{
\item{x}{Corpus object.}

\item{result}{Search result from a search.}
}
\description{
The function remote controls 'Praat' by using 'sendpraat' and a 'Praat' script. 
It opens a search result in the 'Praat' TextGrid Editor.
}
\details{
To make this function work you need to set the path to the 'sendpraat' executable using 'options(act.path.sendpraat = ...)'.
}
\examples{
library(act)
mysearch <- act::search_new(x=examplecorpus, pattern = "pero")

# You can only use this functions if you have located the 'sendpraat' executable properly
# in the package options.
\dontrun{
act::praat_open_result(x=examplecorpus, result=mysearch@results[1,])
}
}
