\name{inverse.rle2}
\alias{inverse.rle2}
\title{
Inverse run length encoding
}
\description{
Re-construct vector compressed by rle2.
}
\usage{
inverse.rle2(x)
}
\arguments{
  \item{x}{
Object returned by rle2.
}
}
\value{
Numeric or character vector.
}
\references{
Acknowledgment: This material is based upon work supported by the National Science Foundation Graduate Research Fellowship under Grant No. DGE-0940903.
}
\author{
Dane R. Van Domelen
}
\note{
This function expands a vector compressed by rle2. It basically just re-formats the object generated by rle2 and then calls inverse.rle. It also works on vectors compressed by rle, but there is no advantage to using inverse.rle2 rather than inverse.rle in that scenario.
}
\seealso{
\code{\link{rle2}}, \code{\link{rle}}, \code{\link{inverse.rle}}
}
\examples{
# Create dummie vector x
x <- c(0, 0, 0, -1, -1, 10, 10, 4, 6, 6)

# Summarize x using rle2
x.summarized <- rle2(x)

# Reconstruct x
x.reconstructed <- inverse.rle2(x.summarized)
}
\keyword{ rle }