% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compliance.R
\name{create_compliance_job}
\alias{create_compliance_job}
\title{Create Compliance Job}
\usage{
create_compliance_job(
  x,
  type = "tweets",
  bearer_token = get_bearer(),
  force_ids = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{either a character vector of Tweet IDs or user IDs; or a plain text file that each line contains a Tweet ID or user ID.}

\item{type}{the type of the job, whether "tweets" or "users".}

\item{bearer_token}{string, bearer token}

\item{force_ids}{logical, make sure \code{x} is treated as a character vector of Tweet IDs or user IDs.}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}
}
\value{
the job ID (invisibly)
}
\description{
This function creates a new compliance job and upload the Tweet IDs or user IDs. By default, the parameter \code{x} with the length of one is assumed to be a text file containing either Tweet IDs or iser IDs. This default behavior can be bypassed using \code{force_ids} For example, if you want to check for just a single Tweet ID.
}
\examples{
\dontrun{
create_compliance_job(x = "tweetids.txt", type = "tweets")
}
}
