% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abcrlda.R
\name{predict.abcrlda}
\alias{predict.abcrlda}
\title{Class Prediction for abcrlda objects}
\usage{
\method{predict}{abcrlda}(object, newx, ...)
}
\arguments{
\item{object}{An object of class "abcrlda".}

\item{newx}{Matrix of new values for x at which predictions are to be made.}

\item{...}{Argument used by generic function predict(object, x, ...).}
}
\value{
Returns factor vector with predictions (i.e., assigned labels) for each observation. Factor levels are inhereted from the object variable.
}
\description{
Classifies observations based on a given abcrlda object.
}
\section{Reference}{

  A. Zollanvari, M. Abdirash, A. Dadlani and B. Abibullaev,
  "Asymptotically Bias-Corrected Regularized Linear Discriminant Analysis for Cost-Sensitive
  Binary Classification," in IEEE Signal Processing Letters, vol. 26, no. 9, pp. 1300-1304,
  Sept. 2019. doi: 10.1109/LSP.2019.2918485
  URL: \url{http://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=8720003&isnumber=8770167}
}

\examples{
data(iris)
train_data <- iris[which(iris[, ncol(iris)] == "virginica" |
                           iris[, ncol(iris)] == "versicolor"), 1:4]
train_label <- factor(iris[which(iris[, ncol(iris)] == "virginica" |
                                   iris[, ncol(iris)] == "versicolor"), 5])
model <- abcrlda(train_data, train_label, gamma = 0.5, cost = 0.75)
a <- predict(model, train_data)
# same params but more explicit
model <- abcrlda(train_data, train_label, gamma = 0.5, cost = c(0.75, 0.25))
b <- predict(model, train_data)
# same class costs ratio
model <- abcrlda(train_data, train_label, gamma = 0.5, cost = c(3, 1))
c <- predict(model, train_data)
# all this model will give the same predictions
all(a == b & a == c & b == c)
#' [1] TRUE
}
\seealso{
Other functions in the package: \code{\link{abcrlda}},
  \code{\link{cross_validation}},
  \code{\link{da_risk_estimator}},
  \code{\link{grid_search}}, \code{\link{risk_calculate}}
}
\concept{functions in the package}
