% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPUw.R
\name{aSPUw}
\alias{aSPUw}
\title{Inverse variance weighted Sum of Powered Score tests (SPUw) and adaptive SPUw (aSPUw) test for single trait - SNP set association.}
\usage{
aSPUw(Y, X, cov = NULL, resample = c("perm", "sim", "boot"),
  model = c("gaussian", "binomial"), pow = c(1:8, Inf), n.perm = 1000)
}
\arguments{
\item{Y}{Response or phenotype data. It can be a disease indicator; =0 for controls, =1 for cases.
Or it can be a quantitative trait. A vector with length n (number of observations).}

\item{X}{Genotype or other data; each row for a subject, and each column
for an SNP (or a predictor). The value of each SNP is the # of the copies
for an allele. A matrix with dimension n by p (n : number of observation, p : number of SNPs (or predictors) ).}

\item{cov}{Covariates. A matrix with dimension n by k (n :number of observation, k : number of covariates).}

\item{resample}{Use "perm" for residual permutations, "sim" for simulations from the null distribution, and "boot" for parametric bootstrap.}

\item{model}{Use "gaussian" for a quantitative trait, and use "binomial" for a binary trait.}

\item{pow}{power used in SPU test. A vector of the powers.}

\item{n.perm}{number of permutations or bootstraps.}
}
\value{
A list object, Ts : Test Statistics for the SPUw and aSPUw test.
        pvs : p-values for the SPUw and aSPUw test.
}
\description{
It gives the p-values of the SPUw tests and aSPUw test based
on the permutations of the residuals or simulations from the null distripution.
}
\examples{

data(exdat)
out <- aSPUw(exdat$Y, exdat$X, pow = c(1:8, Inf), n.perm = 1000)

out$Ts
# This is a vector of Test Statistics for SPU and aSPU tests.
# SPU1 to SPUInf corresponds with the option pow=c(1:8, Inf)
# They are SPU test statistics.
# The last element aSPU is minimum of them, aSPU statistic.

out$pvs
# This is a vector of p-values for SPU and aSPU tests.
# SPU1 to SPUInf corresponds with the option pow=c(1:8, Inf)
# They are p-values for corresponding SPU tests.
# The last element is p-value of aSPU test.

}
\author{
Il-Youp Kwak, Junghi Kim and Wei Pan
}
\references{
Junghi Kim, Jeffrey R Wozniak, Bryon A Mueller, Xiaotong Shen and Wei Pan (2014)
Comparison of statistical tests for group differences in brain functional networks,
Neuroimage, 1;101:681-694
}
\seealso{
\code{\link{aSPU}}
}

