% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_skeleton.R
\name{simplify_skeleton}
\alias{simplify_skeleton}
\alias{simplify_skeleton,aRchi-method}
\title{Simplify a skeleton by removing unnecessary cylinders}
\usage{
simplify_skeleton(aRchi, seg_length = 0.1)

\S4method{simplify_skeleton}{aRchi}(aRchi, seg_length = 0.1)
}
\arguments{
\item{aRchi}{an object of class aRchi containing at least a QSM.}

\item{seg_length}{numeric. The target maximal cylinder length. See details.}
}
\value{
a aRchi file with the simplified QSM.
}
\description{
Simplify a skeleton by removing unnecessary cylinders
}
\details{
Simplifies a QSM by merging short cylinders into longer cylinders with
         a length close to a user defined target length. Note that short cylinders are
         kept if they support a branching point so that the overall QSM geometry
         is not affected by the simplification process.
}
\examples{
\donttest{
# import a point cloud
tls=system.file("extdata","Tree_2_point_cloud.las",package = "aRchi")
tls = lidR::readLAS(tls)

aRchi = aRchi::build_aRchi()
aRchi = aRchi::add_pointcloud(aRchi,point_cloud = tls)

# build a skeleton from the point cloud
aRchi = aRchi::skeletonize_pc(aRchi)

# simplyfy the skeleton
aRchi = aRchi::simplify_skeleton(aRchi,seg_length = 0.05)

# plot the simplifyed skeleton
plot(aRchi,show_point_cloud = TRUE)
}
}
