% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_operations.R
\docType{methods}
\name{get_operations}
\alias{get_operations}
\alias{get_operations,aRchi-method}
\title{Get the nodes from an object of class aRchi}
\usage{
get_operations(aRchi)

\S4method{get_operations}{aRchi}(aRchi)
}
\arguments{
\item{aRchi}{The object of class aRchi}
}
\description{
Show a list with all the operations (and their parameters) that have been performed on an object of class aRchi
}
\examples{
\dontrun{
# Read an aRchi file with a QSM and paths tables.
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)

# Making some operations
Tree1_aRchi<-Make_Path(Tree1_aRchi)
Tree1_aRchi=Compute_A0(Tree1_aRchi)
Tree1_aRchi=Compute_Mf(Tree1_aRchi,WoodDensity = 550)
Tree1_aRchi=Clean_QSM(Tree1_aRchi,threshold = 0.5)

# Show the oprations and their parameters
get_operations(Tree1_aRchi)
}
}
\seealso{
\code{\link{get_QSM}}; \code{\link{get_pointcloud}}; \code{\link{get_paths}}
}
