% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fibonacci.R
\name{Fibonacci}
\alias{Fibonacci}
\alias{A000045}
\title{Fibonacci numbers}
\usage{
Fibonacci(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000045}{A000045}, the \emph{n}th \emph{Fibonnaci} number is given as
\deqn{F_n = F_{n-1} + F_{n-2}}
where the first 6 entries are 0, 1, 1, 2, 3, 5 with \eqn{n\ge 0.}
}
\examples{
## generate first 30 Fibonacci numbers
first30 = Fibonacci(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
