% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetRateSummary.R
\name{GetRateSummary}
\alias{GetRateSummary}
\title{Make request to Zillow API GetRateSummary Web Service}
\usage{
GetRateSummary(
  state = NULL,
  zws_id = getOption("ZillowR-zws_id"),
  url = "http://www.zillow.com/webservice/GetRateSummary.htm"
)
}
\arguments{
\item{state}{The state for which to return average mortgage rates. Two-letter
state abbreviations should be used (AK, AL, AR, AZ, CA, CO, CT, DE, FL,
GA, HI, IA, ID, IL, IN, KS, KY, LA, MA, MD, ME, MI, MN, MO, MS, MT, NC,
ND, NE, NH, NJ, NM, NV, NY, OH, OK, OR, PA, RI, SC, SD, TN, TX, UT, VA,
VT, WA, DC, WI, WV, WY). If omitted, national average mortgage rates are
returned.}

\item{zws_id}{The Zillow Web Service Identifier. Required.}

\item{url}{URL for the GetRateSummary Web Service. Required.}
}
\value{
A named list with the following elements:
\describe{
\item{\strong{request}}{a list with the request parameters}
\item{\strong{message}}{a list of status code(s) and message(s)
returned by the API}
\item{\strong{response}}{an XMLNode with the API-specific response
values. At this time, no further coercion is performed, so you
may have to use functions from the \code{XML} package to extract
the desired output.}
}
}
\description{
The GetRateSummary API returns the current rates per loan type -- as well as
rates from a week ago -- from Zillow Mortgage Marketplace. Current supported
loan types are 30-year fixed, 15-year fixed, and 5/1 ARM. Rates are computed
from real quotes borrowers receive from lenders just seconds before the rate
data is returned. The GetRateSummary API returns rates for a specific state
if the optional state parameter is used.
}
\examples{
\dontrun{
GetRateSummary()
GetRateSummary(state = 'WA')}
}
