% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetChart.R
\name{GetChart}
\alias{GetChart}
\title{Make request to Zillow API GetChart Web Service}
\usage{
GetChart(
  zpid = NULL,
  unit_type = c("percent", "dollar"),
  width = NULL,
  height = NULL,
  chartDuration = c("1year", "5years", "10years"),
  zws_id = getOption("ZillowR-zws_id"),
  url = "http://www.zillow.com/webservice/GetChart.htm"
)
}
\arguments{
\item{zpid}{The Zillow Property ID for the property for which to obtain
information. Required.}

\item{unit_type}{A string value that specifies whether to show the percent
change (unit_type = 'percent') or dollar change (unit_type = 'dollar').
Required.}

\item{width}{An integer value that specifies the width of the generated
image; the value must be between 200 and 600, inclusive.}

\item{height}{An integer value that specifies the height of the generated
image; the value must be between 100 and 300, inclusive.}

\item{chartDuration}{The duration of past data that needs to be shown in the
chart. Valid values are '1year', '5years' and '10years'. If unspecified,
the value defaults to '1year'.}

\item{zws_id}{The Zillow Web Service Identifier. Required.}

\item{url}{URL for the GetChart Web Service. Required.}
}
\value{
A named list with the following elements:
\describe{
\item{\strong{request}}{a list with the request parameters}
\item{\strong{message}}{a list of status code(s) and message(s)
returned by the API}
\item{\strong{response}}{an XMLNode with the API-specific response
values. At this time, no further coercion is performed, so you
may have to use functions from the \code{XML} package to extract
the desired output.}
}
}
\description{
The GetChart API generates a URL for an image file that displays historical
Zestimates for a specific property. The API accepts as input the Zillow
Property ID as well as a chart type: either percentage or dollar value
change. Optionally, the API accepts width and height parameters that
constrain the size of the image. The historical data can be for the past 1
year, 5 years or 10 years.
}
\examples{
\dontrun{
GetChart(zpid = 48749425)
GetChart(zpid = 48749425, unit_type = 'dollar', width = 600, height = 300,
         chartDuration = '10years')}
}
