% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{from_zelig_model}
\alias{from_zelig_model}
\title{Extract the original fitted model object from a \code{zelig} estimation}
\usage{
from_zelig_model(obj)
}
\arguments{
\item{obj}{a zelig object with an estimated model}
}
\description{
Extract the original fitted model object from a \code{zelig} estimation
}
\details{
Extracts the original fitted model object from a \code{zelig}
  estimation. This can be useful for passing output to non-Zelig
  post-estimation functions and packages such as texreg and stargazer
  for creating well-formatted presentation document tables.
}
\examples{
z5 <- zls$new()
z5$zelig(Fertility ~ Education, data = swiss)
from_zelig_model(z5)

}
\author{
Christopher Gandrud
}
