% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_class_01_XiMpLe.node.R, R/zzz_is_get_utils.R
\docType{class}
\name{XiMpLe.node,-class}
\alias{XiMpLe.node,-class}
\alias{XiMpLe.node-class}
\alias{is.XiMpLe.node}
\title{Class XiMpLe.node}
\usage{
is.XiMpLe.node(x)
}
\arguments{
\item{x}{An arbitrary \code{R} object.}
}
\description{
This class is used to create DOM trees of XML documents, like objects that are returned
by \code{\link[XiMpLe:parseXMLTree]{parseXMLTree}}.
}
\details{
There are certain special values predefined for the \code{name} slot to easily create special XML elements:
\describe{
    \item{\code{name=""}}{If the name is an empty character string,
      a pseudo node is created,
      \code{\link[XiMpLe:pasteXMLNode]{pasteXMLNode}} will paste its \code{value} as plain text.}
    \item{\code{name="!--"}}{Creates a comment tag, i.e.,
      this will comment out all its \code{children}.}
    \item{\code{name="![CDATA["}}{Creates a CDATA section and places all its \code{children} in it.}
    \item{\code{name="*![CDATA["}}{Creates a CDATA section and places all its \code{children} in it,
      where the CDATA markers are
      commented out by \code{/* */}, as is used for JavaScript in XHTML.}
}
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the node (i.e.,
      the XML tag identifier). For special names see details.}

\item{\code{attributes}}{A list of named character values,
      representing the attributes of this node.}

\item{\code{children}}{A list of further objects of class XiMpLe.node,
      representing child nodes of this node.}

\item{\code{value}}{Plain text to be used as the enclosed value of this node. Set to \code{value=""} if you
want a childless node to be forced into an non-empty pair of start and end tags by \code{\link[XiMpLe:pasteXMLNode]{pasteXMLNode}}.}
}}

\keyword{classes}
