% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_data.R
\name{flatten_data}
\alias{flatten_data}
\title{Reformat photogrammetric data for model-based analysis}
\usage{
flatten_data(
  data = NULL,
  priors,
  pixel_counts = data$pixel_counts,
  training_objects = data$training_objects,
  image_info = data$image_info,
  prediction_objects = data$prediction_objects
)
}
\arguments{
\item{data}{A \code{list} object, or similar that includes components 
that describe observations to analyze.  Components are automatically
 extracted into this function's other arguments.  See the remaining 
 documentation for details about required components.}

\item{priors}{\code{list} with elements \code{altitude}, \code{lengths}, 
\code{bias}, and \code{sigma} that parameterize the prior distributions for 
the Bayesian model.  The bias components may specify separate priors for
each UAS/altimeter type combination, or for all barometers at once based on
the information provided for joining.}

\item{pixel_counts}{\code{data.frame} with columns \code{Subject}, 
\code{Measurement}, \code{Image}, and \code{PixelCount} that describe the 
length measurements taken from images}

\item{training_objects}{\code{data.frame} with columns \code{Subject},
\code{Measurement}, and \code{Length} that describe the known lengths of 
the objects used to calibrate the photogrammetric model}

\item{image_info}{\code{data.frame} with columns \code{Image}, 
\code{Barometer}, \code{Laser}, \code{FocalLength}, 
\code{ImageWidth}, and \code{SensorWidth} that describe the images used in 
the photogrammetric study}

\item{prediction_objects}{\code{data.frame} with elements \code{Subject}, 
\code{Measurement}, and \code{Timepoint} that describe the unknown lengths
of objects that should be estimated}
}
\description{
For internal use only.  Not intended to be called directly by users.
}
\details{
Assemble \code{data.frame} objects into a format that can be analyzed using 
numerical methods.  This function is analagous to \code{stats::model.matrix},
which generates design matrices for models that are specified via formulas.
}
\examples{
# load example wide-format data
data("calibration")
data("whales")

# parse calibration study
calibration_data = parse_observations(
  x = calibration, 
  subject_col = 'CO.ID',
  meas_col = 'Lpix', 
  tlen_col = 'CO.L', 
  image_col = 'image', 
  barometer_col = 'Baro_Alt',
  laser_col = 'Laser_Alt', 
  flen_col = 'Focal_Length', 
  iwidth_col = 'Iw', 
  swidth_col = 'Sw',
  uas_col = 'uas'
)

# parse field study
whale_data = parse_observations(
  x = whales, 
  subject_col = 'whale_ID',
  meas_col = 'TL.pix', 
  image_col = 'Image', 
  barometer_col = 'AltitudeBarometer',
  laser_col = 'AltitudeLaser', 
  flen_col = 'FocalLength', 
  iwidth_col = 'ImageWidth', 
  swidth_col = 'SensorWidth', 
  uas_col = 'UAS',
  timepoint_col = 'year'
)

# combine parsed calibration and observation (whale) data
combined_data = combine_observations(calibration_data, whale_data)
}
