/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.integration.r;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.StyleAction;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.data.ReadStrategy;
import com.miraisolutions.xlconnect.integration.r.RCellStyleWrapper;
import com.miraisolutions.xlconnect.integration.r.RDataFrameWrapper;
import com.miraisolutions.xlconnect.utils.RepeatableIterableUtils;
import com.miraisolutions.xlconnect.utils.SequenceLengthEncoding;
import com.miraisolutions.xlconnect.utils.SimpleSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RWorkbookWrapper {
    private final Workbook workbook;

    public RWorkbookWrapper(String filename, String password, boolean create) throws IOException, InvalidFormatException {
        this.workbook = Workbook.getWorkbook(filename, password, create);
    }

    public RWorkbookWrapper(String filename, boolean create) throws IOException, InvalidFormatException {
        this.workbook = Workbook.getWorkbook(filename, create);
    }

    public String[] getSheets() {
        return this.workbook.getSheets();
    }

    public int getSheetPos(String sheetName) {
        return this.workbook.getSheetPos(sheetName);
    }

    public void setSheetPos(String sheetName, int pos) {
        this.workbook.setSheetPos(sheetName, pos);
    }

    public String[] getDefinedNames(boolean validOnly) {
        return this.workbook.getDefinedNames(validOnly);
    }

    public void createSheet(String name) {
        this.workbook.createSheet(name);
    }

    public void createName(String name, String formula, boolean overwrite) {
        this.workbook.createName(name, formula, overwrite);
    }

    public void removeName(String name) {
        this.workbook.removeName(name);
    }

    public String getReferenceFormula(String name) {
        return this.workbook.getReferenceFormula(name);
    }

    public void removeSheet(String name) {
        this.workbook.removeSheet(name);
    }

    public void removeSheet(int sheetIndex) {
        this.workbook.removeSheet(sheetIndex);
    }

    public void renameSheet(String name, String newName) {
        this.workbook.renameSheet(name, newName);
    }

    public void renameSheet(int sheetIndex, String newName) {
        this.workbook.renameSheet(sheetIndex, newName);
    }

    public void cloneSheet(int index, String newName) {
        this.workbook.cloneSheet(index, newName);
    }

    public void cloneSheet(String name, String newName) {
        this.workbook.cloneSheet(name, newName);
    }

    public void writeNamedRegion(RDataFrameWrapper dataFrame, String name, boolean header) {
        this.workbook.writeNamedRegion(dataFrame.dataFrame, name, header);
    }

    private static DataType[] dataTypeFromString(String[] colTypes) {
        DataType[] ctypes = null;
        if (colTypes != null) {
            ctypes = new DataType[colTypes.length];
            for (int i = 0; i < colTypes.length; ++i) {
                ctypes[i] = RWorkbookWrapper.fromString(colTypes[i]);
            }
        }
        return ctypes;
    }

    public RDataFrameWrapper readNamedRegion(String name, boolean header, String[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, String readStrategy) {
        DataFrame dataFrame = this.workbook.readNamedRegion(name, header, ReadStrategy.valueOf(readStrategy.toUpperCase()), RWorkbookWrapper.dataTypeFromString(colTypes), forceConversion, dateTimeFormat, takeCached, subset);
        return new RDataFrameWrapper(dataFrame);
    }

    public RDataFrameWrapper readTable(int worksheetIndex, String tableName, boolean header, String[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, String readStrategy) {
        DataFrame dataFrame = this.workbook.readTable(worksheetIndex, tableName, header, ReadStrategy.valueOf(readStrategy.toUpperCase()), RWorkbookWrapper.dataTypeFromString(colTypes), forceConversion, dateTimeFormat, takeCached, subset);
        return new RDataFrameWrapper(dataFrame);
    }

    public RDataFrameWrapper readTable(String worksheetName, String tableName, boolean header, String[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, String readStrategy) {
        DataFrame dataFrame = this.workbook.readTable(worksheetName, tableName, header, ReadStrategy.valueOf(readStrategy.toUpperCase()), RWorkbookWrapper.dataTypeFromString(colTypes), forceConversion, dateTimeFormat, takeCached, subset);
        return new RDataFrameWrapper(dataFrame);
    }

    public boolean existsName(String name) {
        return this.workbook.existsName(name);
    }

    public boolean existsSheet(String name) {
        return this.workbook.existsSheet(name);
    }

    public RDataFrameWrapper readWorksheet(int worksheetIndex, int startRow, int startCol, int endRow, int endCol, boolean header, String[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, String readStrategy) {
        DataFrame dataFrame = this.workbook.readWorksheet(worksheetIndex, startRow, startCol, endRow, endCol, header, ReadStrategy.valueOf(readStrategy.toUpperCase()), RWorkbookWrapper.dataTypeFromString(colTypes), forceConversion, dateTimeFormat, takeCached, subset, false, false);
        return new RDataFrameWrapper(dataFrame);
    }

    public RDataFrameWrapper readWorksheet(String worksheet, int startRow, int startCol, int endRow, int endCol, boolean header, String[] colTypes, boolean forceConversion, String dateTimeFormat, boolean takeCached, int[] subset, String readStrategy) {
        DataFrame dataFrame = this.workbook.readWorksheet(worksheet, startRow, startCol, endRow, endCol, header, ReadStrategy.valueOf(readStrategy.toUpperCase()), RWorkbookWrapper.dataTypeFromString(colTypes), forceConversion, dateTimeFormat, takeCached, subset, false, false);
        return new RDataFrameWrapper(dataFrame);
    }

    public void writeWorksheet(RDataFrameWrapper dataFrame, int worksheetIndex, int startRow, int startCol, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetIndex, startRow, startCol, header);
    }

    public void writeWorksheet(RDataFrameWrapper dataFrame, String worksheetName, int startRow, int startCol, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetName, startRow, startCol, header);
    }

    public void writeWorksheet(RDataFrameWrapper dataFrame, int worksheetIndex, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetIndex, header);
    }

    public void writeWorksheet(RDataFrameWrapper dataFrame, String worksheetName, boolean header) {
        this.workbook.writeWorksheet(dataFrame.dataFrame, worksheetName, header);
    }

    public int getActiveSheetIndex() {
        return this.workbook.getActiveSheetIndex();
    }

    public String getActiveSheetName() {
        return this.workbook.getActiveSheetName();
    }

    public void setActiveSheet(int sheetIndex) {
        this.workbook.setActiveSheet(sheetIndex);
    }

    public void setActiveSheet(String sheetName) {
        this.workbook.setActiveSheet(sheetName);
    }

    public void hideSheet(int sheetIndex, boolean veryHidden) {
        this.workbook.hideSheet(sheetIndex, veryHidden);
    }

    public void hideSheet(String sheetName, boolean veryHidden) {
        this.workbook.hideSheet(sheetName, veryHidden);
    }

    public void unhideSheet(int sheetIndex) {
        this.workbook.unhideSheet(sheetIndex);
    }

    public void unhideSheet(String sheetName) {
        this.workbook.unhideSheet(sheetName);
    }

    public boolean isSheetHidden(int sheetIndex) {
        return this.workbook.isSheetHidden(sheetIndex);
    }

    public boolean isSheetHidden(String sheetName) {
        return this.workbook.isSheetHidden(sheetName);
    }

    public boolean isSheetVeryHidden(int sheetIndex) {
        return this.workbook.isSheetVeryHidden(sheetIndex);
    }

    public boolean isSheetVeryHidden(String sheetName) {
        return this.workbook.isSheetVeryHidden(sheetName);
    }

    public void addImage(String filename, String name, boolean originalSize) throws FileNotFoundException, IOException {
        this.workbook.addImage(filename, name, originalSize);
    }

    public RCellStyleWrapper createCellStyle(String name) {
        CellStyle cs = this.workbook.createCellStyle(name);
        return new RCellStyleWrapper(cs);
    }

    public RCellStyleWrapper createCellStyle() {
        CellStyle cs = this.workbook.createCellStyle();
        return new RCellStyleWrapper(cs);
    }

    public RCellStyleWrapper getCellStyle(String name) {
        CellStyle cs = this.workbook.getCellStyle(name);
        if (cs != null) {
            return new RCellStyleWrapper(cs);
        }
        throw new IllegalArgumentException("Cell style " + name + " does not exist");
    }

    public boolean existsCellStyle(String name) {
        return this.workbook.existsCellStyle(name);
    }

    public void setMissingValue(Object[] value) {
        this.workbook.setMissingValue(value);
    }

    private static DataType fromString(String dataType) {
        if ("BOOLEAN".equals(dataType)) {
            return DataType.Boolean;
        }
        if ("NUMERIC".equals(dataType)) {
            return DataType.Numeric;
        }
        if ("STRING".equals(dataType)) {
            return DataType.String;
        }
        if ("DATETIME".equals(dataType)) {
            return DataType.DateTime;
        }
        throw new IllegalArgumentException("Provided data type is not a valid data type!");
    }

    public void setDataFormat(String dataType, String format) {
        this.workbook.setDataFormat(RWorkbookWrapper.fromString(dataType), format);
    }

    public void setCellStyleForDataType(String dataType, RCellStyleWrapper cellStyle) {
        this.workbook.setCellStyleForDataType(RWorkbookWrapper.fromString(dataType), cellStyle.cellStyle);
    }

    public RCellStyleWrapper getCellStyleForDataType(String dataType) {
        return new RCellStyleWrapper(this.workbook.getCellStyleForDataType(RWorkbookWrapper.fromString(dataType)));
    }

    public void setStyleAction(String action) {
        if ("XLCONNECT".equals(action)) {
            this.workbook.setStyleAction(StyleAction.XLCONNECT);
        } else if ("DATATYPE".equals(action)) {
            this.workbook.setStyleAction(StyleAction.DATATYPE);
        } else if ("NONE".equals(action)) {
            this.workbook.setStyleAction(StyleAction.NONE);
        } else if ("PREDEFINED".equals(action)) {
            this.workbook.setStyleAction(StyleAction.PREDEFINED);
        } else if ("STYLE_NAME_PREFIX".equals(action)) {
            this.workbook.setStyleAction(StyleAction.STYLE_NAME_PREFIX);
        } else if ("DATA_FORMAT_ONLY".equals(action)) {
            this.workbook.setStyleAction(StyleAction.DATA_FORMAT_ONLY);
        } else {
            throw new IllegalArgumentException("Provided action is not a valid style action!");
        }
    }

    public void setStyleNamePrefix(String prefix) {
        this.workbook.setStyleNamePrefix(prefix);
    }

    public void setCellStyleSheetName(SimpleSequence<String> sheetName, SequenceLengthEncoding row, SequenceLengthEncoding col, SimpleSequence<RCellStyleWrapper> cellStyle) {
        RepeatableIterableUtils.foreach(sheetName, row, col, cellStyle, new RepeatableIterableUtils.Function4<String, Integer, Integer, RCellStyleWrapper>(){

            @Override
            public void apply(String sheet, Integer row, Integer col, RCellStyleWrapper cellStyle) {
                RWorkbookWrapper.this.workbook.setCellStyle(sheet, (int)row, (int)col, cellStyle.cellStyle);
            }
        });
    }

    public void setCellStyleSheetIndex(SimpleSequence<Integer> sheetIndex, SequenceLengthEncoding row, SequenceLengthEncoding col, SimpleSequence<RCellStyleWrapper> cellStyle) {
        RepeatableIterableUtils.foreach(sheetIndex, row, col, cellStyle, new RepeatableIterableUtils.Function4<Integer, Integer, Integer, RCellStyleWrapper>(){

            @Override
            public void apply(Integer sheet, Integer row, Integer col, RCellStyleWrapper cellStyle) {
                RWorkbookWrapper.this.workbook.setCellStyle(sheet, (int)row, (int)col, cellStyle.cellStyle);
            }
        });
    }

    public void setCellStyleFormula(String formula, RCellStyleWrapper cellStyle) {
        this.workbook.setCellStyle(formula, cellStyle.cellStyle);
    }

    public void setHyperlinkSheetIndex(SimpleSequence<Integer> sheetIndex, SequenceLengthEncoding row, SequenceLengthEncoding col, SimpleSequence<String> type, SimpleSequence<String> address) {
        RepeatableIterableUtils.foreach(sheetIndex, row, col, type, address, new RepeatableIterableUtils.Function5<Integer, Integer, Integer, String, String>(){

            @Override
            public void apply(Integer sheet, Integer row, Integer col, String type, String address) {
                RWorkbookWrapper.this.workbook.setHyperlink(sheet, (int)row, (int)col, HyperlinkType.valueOf((String)type), address);
            }
        });
    }

    public void setHyperlinkSheetName(SimpleSequence<String> sheetName, SequenceLengthEncoding row, SequenceLengthEncoding col, SimpleSequence<String> type, SimpleSequence<String> address) {
        RepeatableIterableUtils.foreach(sheetName, row, col, type, address, new RepeatableIterableUtils.Function5<String, Integer, Integer, String, String>(){

            @Override
            public void apply(String sheet, Integer row, Integer col, String type, String address) {
                RWorkbookWrapper.this.workbook.setHyperlink(sheet, (int)row, (int)col, HyperlinkType.valueOf((String)type), address);
            }
        });
    }

    public void setHyperlinkFormula(String formula, String type, String address) {
        this.workbook.setHyperlink(formula, HyperlinkType.valueOf((String)type), address);
    }

    public void setColumnWidth(int sheetIndex, int columnIndex, int width) {
        this.workbook.setColumnWidth(sheetIndex, columnIndex, width);
    }

    public void setColumnWidth(String sheetName, int columnIndex, int width) {
        this.workbook.setColumnWidth(sheetName, columnIndex, width);
    }

    public void setRowHeight(int sheetIndex, int rowIndex, double height) {
        this.workbook.setRowHeight(sheetIndex, rowIndex, (float)height);
    }

    public void setRowHeight(String sheetName, int rowIndex, double height) {
        this.workbook.setRowHeight(sheetName, rowIndex, (float)height);
    }

    public void mergeCells(int sheetIndex, String reference) {
        this.workbook.mergeCells(sheetIndex, reference);
    }

    public void mergeCells(String sheetName, String reference) {
        this.workbook.mergeCells(sheetName, reference);
    }

    public void unmergeCells(int sheetIndex, String reference) {
        this.workbook.unmergeCells(sheetIndex, reference);
    }

    public void unmergeCells(String sheetName, String reference) {
        this.workbook.unmergeCells(sheetName, reference);
    }

    public String[] retrieveWarnings() {
        return this.workbook.retrieveWarnings();
    }

    public void onErrorCell(String behavior) {
        if ("STOP".equals(behavior)) {
            this.workbook.onErrorCell(ErrorBehavior.THROW_EXCEPTION);
        } else {
            this.workbook.onErrorCell(ErrorBehavior.WARN);
        }
    }

    public void save(String file) throws IOException {
        this.workbook.save(file);
    }

    public void save() throws IOException {
        this.workbook.save();
    }

    public void setCellFormula(String sheetName, int row, int col, String formula) {
        this.workbook.setCellFormula(sheetName, row, col, formula);
    }

    public void setCellFormula(int sheetIndex, int row, int col, String formula) {
        this.workbook.setCellFormula(sheetIndex, row, col, formula);
    }

    public String getCellFormula(int sheetIndex, int row, int col) {
        return this.workbook.getCellFormula(sheetIndex, row, col);
    }

    public String getCellFormula(String sheetName, int row, int col) {
        return this.workbook.getCellFormula(sheetName, row, col);
    }

    public int[] getReferenceCoordinates(String name) {
        return this.workbook.getReferenceCoordinates(name);
    }

    public int[] getReferenceCoordinatesForName(String name) {
        return this.workbook.getReferenceCoordinatesForName(name);
    }

    public int[] getReferenceCoordinatesForTable(int sheetIndex, String tableName) {
        return this.workbook.getReferenceCoordinatesForTable(sheetIndex, tableName);
    }

    public int[] getReferenceCoordinatesForTable(String sheetName, String tableName) {
        return this.workbook.getReferenceCoordinatesForTable(sheetName, tableName);
    }

    public void setForceFormulaRecalculation(int sheetIndex, boolean value) {
        this.workbook.setForceFormulaRecalculation(sheetIndex, value);
    }

    public void setForceFormulaRecalculation(String sheetName, boolean value) {
        this.workbook.setForceFormulaRecalculation(sheetName, value);
    }

    public boolean getForceFormulaRecalculation(int sheetIndex) {
        return this.workbook.getForceFormulaRecalculation(sheetIndex);
    }

    public boolean getForceFormulaRecalculation(String sheetName) {
        return this.workbook.getForceFormulaRecalculation(sheetName);
    }

    public void setAutoFilter(int sheetIndex, String reference) {
        this.workbook.setAutoFilter(sheetIndex, reference);
    }

    public void setAutoFilter(String sheetName, String reference) {
        this.workbook.setAutoFilter(sheetName, reference);
    }

    public int getLastRow(int sheetIndex) {
        return this.workbook.getLastRow(sheetIndex);
    }

    public int getLastRow(String sheetName) {
        return this.workbook.getLastRow(sheetName);
    }

    public int getLastColumn(int sheetIndex) {
        return this.workbook.getLastColumn(sheetIndex);
    }

    public int getLastColumn(String sheetName) {
        return this.workbook.getLastColumn(sheetName);
    }

    public void appendNamedRegion(RDataFrameWrapper data, String name, boolean header) {
        this.workbook.appendNamedRegion(data.dataFrame, name, header);
    }

    public void appendWorksheet(RDataFrameWrapper data, int worksheetIndex, boolean header) {
        this.workbook.appendWorksheet(data.dataFrame, worksheetIndex, header);
    }

    public void appendWorksheet(RDataFrameWrapper data, String worksheetName, boolean header) {
        this.workbook.appendWorksheet(data.dataFrame, worksheetName, header);
    }

    public void clearSheet(int sheetIndex) {
        this.workbook.clearSheet(sheetIndex);
    }

    public void clearSheet(String sheetName) {
        this.workbook.clearSheet(sheetName);
    }

    public void clearRange(int sheetIndex, int[] coords) {
        this.workbook.clearRange(sheetIndex, coords);
    }

    public void clearRange(String sheetName, int[] coords) {
        this.workbook.clearRange(sheetName, coords);
    }

    public void clearRangeFromReference(String reference) {
        this.workbook.clearRangeFromReference(reference);
    }

    public void clearNamedRegion(String name) {
        this.workbook.clearNamedRegion(name);
    }

    public void createFreezePane(int sheetIndex, int colSplit, int rowSplit, int leftColumn, int topRow) {
        this.workbook.createFreezePane(sheetIndex, colSplit, rowSplit, leftColumn, topRow);
    }

    public void createFreezePane(String sheetName, int colSplit, int rowSplit, int leftColumn, int topRow) {
        this.workbook.createFreezePane(sheetName, colSplit, rowSplit, leftColumn, topRow);
    }

    public void createFreezePane(int sheetIndex, int colSplit, int rowSplit) {
        this.workbook.createFreezePane(sheetIndex, colSplit, rowSplit);
    }

    public void createFreezePane(String sheetName, int colSplit, int rowSplit) {
        this.workbook.createFreezePane(sheetName, colSplit, rowSplit);
    }

    public void createSplitPane(int sheetIndex, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.workbook.createSplitPane(sheetIndex, xSplitPos, ySplitPos, leftColumn, topRow);
    }

    public void createSplitPane(String sheetName, int xSplitPos, int ySplitPos, int leftColumn, int topRow) {
        this.workbook.createSplitPane(sheetName, xSplitPos, ySplitPos, leftColumn, topRow);
    }

    public void removePane(int sheetIndex) {
        this.workbook.removePane(sheetIndex);
    }

    public void removePane(String sheetName) {
        this.workbook.removePane(sheetName);
    }

    public void setSheetColor(int sheetIndex, int color) {
        this.workbook.setSheetColor(sheetIndex, color);
    }

    public void setSheetColor(String sheetName, int color) {
        this.workbook.setSheetColor(sheetName, color);
    }

    public int[] getBoundingBox(int sheetIndex, int startRow, int startCol, int endRow, int endCol, boolean autofitRow, boolean autofitCol) {
        return this.workbook.getBoundingBox(sheetIndex, startRow, startCol, endRow, endCol, autofitRow, autofitCol);
    }

    public int[] getBoundingBox(String sheetName, int startRow, int startCol, int endRow, int endCol, boolean autofitRow, boolean autofitCol) {
        return this.workbook.getBoundingBox(sheetName, startRow, startCol, endRow, endCol, autofitRow, autofitCol);
    }

    public String[] getTables(int sheetIndex) {
        return this.workbook.getTables(sheetIndex);
    }

    public String[] getTables(String sheetName) {
        return this.workbook.getTables(sheetName);
    }
}

