% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xColormap.r
\name{xColormap}
\alias{xColormap}
\title{Function to define a colormap}
\usage{
xColormap(colormap = c("bwr", "jet", "gbr", "wyr", "br", "yr",
"rainbow",
"wb", "heat", "terrain", "topo", "cm", "ggplot2", "jet.top",
"jet.bottom",
"jet.both", "spectral", "ggplot2.top", "ggplot2.bottom",
"ggplot2.both",
"RdYlBu"), interpolate = c("spline", "linear"))
}
\arguments{
\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap),
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta), and "ggplot2" (emulating ggplot2
default color palette). Alternatively, any hyphen-separated HTML color
names, e.g. "lightyellow-orange" (by default), "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}. It can also be a
function of 'colorRampPalette'}

\item{interpolate}{use spline or linear interpolation}
}
\value{
\itemize{
\item{\code{palette.name}: a function that takes an integer argument
for generating that number of colors interpolating the given sequence}
}
}
\description{
\code{xColormap} is supposed to define a colormap. It returns a
function, which will take an integer argument specifying how many
colors interpolate the given colormap.
}
\note{
The input colormap includes:
\itemize{
\item{"jet": jet colormap}
\item{"bwr": blue-white-red}
\item{"gbr": green-black-red}
\item{"wyr": white-yellow-red}
\item{"br": black-red}
\item{"yr": yellow-red}
\item{"wb": white-black}
\item{"rainbow": rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta}
\item{"ggplot2": emulating ggplot2 default color palette}
\item{"spectral": emulating RColorBrewer spectral color palette}
\item{Alternatively, any hyphen-separated HTML color names, e.g.
"blue-black-yellow", "royalblue-white-sandybrown",
"darkblue-lightblue-lightyellow-darkorange",
"darkgreen-white-darkviolet", "darkgreen-lightgreen-lightpink-darkred".
A list of standard color names can be found in
\url{http://html-color-codes.info/color-names}}
}
}
\examples{
# 1) define "blue-white-red" colormap
palette.name <- xColormap(colormap="bwr")
# use the return function "palette.name" to generate 10 colors spanning "bwr"
palette.name(10)

# 2) define default colormap from ggplot2
palette.name <- xColormap(colormap="ggplot2")
# use the return function "palette.name" to generate 3 default colors used by ggplot2
palette.name(3)

# 3) define brewer colormap called "RdYlBu"
palette.name <- xColormap(colormap="RdYlBu")
# use the return function "palette.name" to generate 3 default colors used by ggplot2
palette.name(3)
}
