% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGGnetwork.r
\name{xGGnetwork}
\alias{xGGnetwork}
\title{Function to visualise an igraph object using ggnetwork}
\usage{
xGGnetwork(g, node.label = NULL, label.wrap.width = NULL,
label.wrap.lineheight = 0.8, node.label.size = NULL,
node.label.fontface = "plain", node.label.color = "darkblue",
node.label.alpha = 0.8, node.label.padding = 1, node.label.arrow =
0.01,
node.label.force = 1, node.shape = 19, node.shape.title = NULL,
node.xcoord = NULL, node.ycoord = NULL, node.color = NULL,
node.color.title = NULL, colormap = "grey-orange-darkred", ncolors =
64,
zlim = NULL, na.color = "grey80", node.size = NULL,
node.size.title = NULL, node.size.range = c(1, 4), slim = NULL,
title = "", edge.size = 0.5, edge.color = "black",
edge.color.alpha = 0.5, edge.curve = 0.1, edge.arrow = 2,
edge.arrow.gap = 0.02)
}
\arguments{
\item{g}{an object of class "igraph". For an advanced use, it can be a
list of igraph objects; in this case, multiple panels will be shown
(particularly useful when visualising the same network but color-coded
differently)}

\item{node.label}{either a vector labelling nodes or a character
specifying which node attribute used for the labelling. If NULL (by
default), no node labelling}

\item{label.wrap.width}{a positive integer specifying wrap width of
node labelling}

\item{label.wrap.lineheight}{line height spacing for text in ggplot. By
default it is 0.8}

\item{node.label.size}{a character specifying which node attribute used
for node label size}

\item{node.label.fontface}{a character specifying which node attribute
used for node label fontface ('plain', 'bold', 'italic',
'bold.italic')}

\item{node.label.color}{a character specifying which node attribute
used for the node label color}

\item{node.label.alpha}{the 0-1 value specifying transparency of node
labelling}

\item{node.label.padding}{the padding around the labeled node}

\item{node.label.arrow}{the arrow pointing to the labeled node}

\item{node.label.force}{the repelling force between overlapping labels}

\item{node.shape}{an integer specifying node shape or a character
specifying which node attribute used for the node shape (no matter
whether it is numeric or character)}

\item{node.shape.title}{a character specifying the title for node
shaping}

\item{node.xcoord}{a vector specifying x coordinates. If NULL, it will
be created using igraph::layout_as_tree}

\item{node.ycoord}{a vector specifying y coordinates. If NULL, it will
be created using igraph::layout_as_tree}

\item{node.color}{a character specifying which node attribute used for
node coloring}

\item{node.color.title}{a character specifying the title for node
coloring}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap),
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta), and "ggplot2" (emulating ggplot2
default color palette). Alternatively, any hyphen-separated HTML color
names, e.g. "lightyellow-orange" (by default), "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{ncolors}{the number of colors specified over the colormap}

\item{zlim}{the minimum and maximum values for which colors should be
plotted}

\item{na.color}{the color for NAs. By default, it is 'grey80'}

\item{node.size}{either a vector specifying node size or a character
specifying which node attribute used for the node size}

\item{node.size.title}{a character specifying the title for node
sizing}

\item{node.size.range}{the range of actual node size}

\item{slim}{the minimum and maximum values for which sizes should be
plotted}

\item{title}{a character specifying the title for the plot}

\item{edge.size}{a numeric value specifying the edge size. By default,
it is 0.5}

\item{edge.color}{a character specifying which edge attribute defining
the the edge colors}

\item{edge.color.alpha}{the 0-1 value specifying transparency of edge
colors}

\item{edge.curve}{a numeric value specifying the edge curve. 0 for the
straight line}

\item{edge.arrow}{a numeric value specifying the edge arrow. By
default, it is 2}

\item{edge.arrow.gap}{a gap between the arrow and the node}
}
\value{
a ggplot object, appended with 'data_nodes' and 'data_edges'
}
\description{
\code{xGGnetwork} is supposed to visualise an igraph object using
ggnetwork.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev/"

###########################
# load REACTOME
# restricted to Immune System ('R-HSA-168256') or Signal Transduction ('R-HSA-162582')
g <- xRDataLoader(RData.customised='ig.REACTOME',
RData.location=RData.location)
neighs.out <- igraph::neighborhood(g, order=vcount(g),
nodes="R-HSA-168256", mode="out")
nodeInduced <- V(g)[unique(unlist(neighs.out))]$name
ig <- igraph::induced.subgraph(g, vids=nodeInduced)

# visualise the graph with vertices being color-coded
V(ig)$degree <- igraph::degree(ig)
gp <- xGGnetwork(g=ig, node.label='term_id', label.wrap.width=30,
node.label.size=2, node.label.color='black', node.label.alpha=0.8,
node.label.padding=0, node.label.arrow=0, node.label.force=1,
node.shape=19, node.xcoord='xcoord', node.ycoord='ycoord',
node.color='degree', node.color.title='Degree',
colormap='grey-orange-darkred', ncolors=64, zlim=c(0,10),
node.size.range=3,
edge.color="black",edge.color.alpha=0.3,edge.curve=0.05,edge.arrow.gap=0.02,
title='')
# advanced use: visualise the list of graphs
ls_ig <- list(ig, ig)
gp <- xGGnetwork(g=ls_ig, node.label='term_id', label.wrap.width=30,
node.label.size=2, node.label.color='black', node.label.alpha=0.8,
node.label.padding=0, node.label.arrow=0, node.label.force=1,
node.shape=19, node.xcoord='xcoord', node.ycoord='ycoord',
node.color='degree', node.color.title='Degree',
colormap='grey-orange-darkred', ncolors=64, zlim=c(0,10),
node.size.range=3,
edge.color="black",edge.color.alpha=0.3,edge.curve=0.05,edge.arrow.gap=0.02,
title='')

###########################
# load PhasedTargets
# restricted to disease ('EFO:0000408') or immune system disease ('EFO:0000540')
g <- xRDataLoader(RData.customised='ig.PhasedTargets',
RData.location=RData.location)
neighs.out <- igraph::neighborhood(g, order=vcount(g),
nodes="EFO:0000408", mode="out")
nodeInduced <- V(g)[unique(unlist(neighs.out))]$name
ig <- igraph::induced.subgraph(g, vids=nodeInduced)

# append with the number of approved and phased targets
dag <- ig
V(dag)$num_approved <- sapply(V(ig)$max_phase,function(x)
sum(x$max_phase>=4))
V(dag)$num_phased <- sapply(V(ig)$max_phase,function(x)
sum(x$max_phase>=0))
# keep nodes with num_approved >=20
dag_ig <- igraph::induced.subgraph(dag,
vids=which(V(dag)$num_approved>=20))
# (optional) further restricted to the direct children of the root
root <- dnet::dDAGroot(dag_ig)
neighs.out <- igraph::neighborhood(dag_ig, order=1, nodes=root,
mode="out")
nodeInduced <- V(dag_ig)[unique(unlist(neighs.out))]$name
dag_ig <- igraph::induced.subgraph(dag_ig, vids=nodeInduced)
# nodes colored by num_approved
V(dag_ig)$node_color <- log2(V(dag_ig)$num_approved)
glayout <- igraph::layout_with_kk(dag_ig)
V(dag_ig)$xcoord <- glayout[,1]
V(dag_ig)$ycoord <- glayout[,2]
gp <- xGGnetwork(g=dag_ig, node.label='term_name', label.wrap.width=30,
node.label.size=2, node.label.color='black', node.label.alpha=0.9,
node.label.padding=0, node.label.arrow=0, node.label.force=0.5,
node.shape=19, node.xcoord='xcoord', node.ycoord='ycoord',
node.color='node_color', node.color.title='Approved\\n(log2-scale)',
colormap='ggplot2.top', ncolors=64, node.size.range=3,
edge.color="orange",edge.color.alpha=0.5,edge.curve=0.05,edge.arrow.gap=0.02,
title='')

###########################
# visualise gene network
glayout <- igraph::layout_with_kk(g)
V(g)$xcoord <- glayout[,1]
V(g)$ycoord <- glayout[,2]
V(g)$degree <- igraph::degree(g)
gp <- xGGnetwork(g=g, node.label='name', node.label.size=2,
node.label.color='black', node.label.alpha=0.8, node.label.padding=0,
node.label.arrow=0, node.label.force=0.01, node.shape=19,
node.xcoord='xcoord', node.ycoord='ycoord', node.color='priority',
node.color.title='5-star\\nrating', colormap='yellow-red', ncolors=64,
zlim=c(0,5), node.size='degree', node.size.title='Degree', slim=c(0,5),
edge.color="orange",edge.color.alpha=0.5,edge.curve=0,edge.arrow.gap=0.025,
title='')
gp_rating <- xGGnetwork(g=g, node.label='name', node.label.size=2,
node.label.color='black', node.label.alpha=0.8, node.label.padding=0.1,
node.label.arrow=0, node.label.force=0.01, node.shape=19,
node.xcoord='xcoord', node.ycoord='ycoord', node.color='priority',
node.color.title='5-star\\nrating', colormap='white-yellow-red',
ncolors=64, zlim=c(0,5), node.size.range=5,
edge.color="orange",edge.color.alpha=0.3,edge.curve=0,edge.arrow.gap=0.02,
title='')
}
}
\seealso{
\code{\link{xGGnetwork}}
}
