% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPstepwise.R
\name{WPSW}
\alias{WPSW}
\title{p-Wasserstein Distance Linear Projections Using a Stepwise Method}
\usage{
WPSW(
  X,
  Y,
  theta,
  power = 2,
  force = NULL,
  direction = c("backward", "forward"),
  method = c("selection.variable", "scale", "projection"),
  transport.method = transport_options(),
  OTmaxit = 100,
  epsilon = 0.05,
  calc.theta = TRUE,
  model.size = NULL,
  parallel = NULL,
  display.progress = FALSE,
  ...
)
}
\arguments{
\item{X}{matrix of covariates}

\item{Y}{matrix of predictions}

\item{theta}{optional parameter matrix for selection methods.}

\item{power}{Power of the Wasserstein distance}

\item{force}{Any covariates to force into the model?}

\item{direction}{forward or backward selection}

\item{method}{"selection.variable" or "projection}

\item{transport.method}{Method for calculating the Wasserstein distance. Should be one of the outputs of \code{\link[=transport_options]{transport_options()}}.}

\item{OTmaxit}{maximum number of iterations for the opt?imal transport methods}

\item{epsilon}{hyperparameter if using sinkhorn iterations to approximate OT}

\item{calc.theta}{should we get the linear coefficients}

\item{model.size}{Maximum model size}

\item{parallel}{foreach backend}

\item{display.progress}{Display intermediate progress}
}
\value{
An object of class \code{WpProj}
}
\description{
p-Wasserstein Distance Linear Projections Using a Stepwise Method
}
\keyword{internal}
