% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_example}
\alias{get_example}
\title{Get an example SPARQL query from Wikidata}
\usage{
get_example(example_name)
}
\arguments{
\item{example_name}{the names of the examples as they appear on
[this page](https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries/examples)}
}
\value{
The SPARQL query as a character vector.
}
\description{
Gets the specified example(s) from
  [SPARQL query service examples page](https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries/examples)
  using [Wikidata's MediaWiki API](https://www.wikidata.org/w/api.php).
}
\details{
If you are planning on extracting multiple examples, please provide
  all the names as a single vector for efficiency.
}
\examples{
\dontrun{
sparql_query <- extract_example(c("Cats", "Horses"))
query_wikidata(sparql_query)
# returns a named list with two data frames
# one called "Cats" and one called "Horses"
sparql_query <- extract_example("Largest cities with female mayor")
cat(sparql_query)
query_wikidata(sparql_query)
}
}
\seealso{
[query_wikidata]
}
