% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writes.R
\name{write_wikidata}
\alias{write_wikidata}
\title{Write statements to Wikidata}
\usage{
write_wikidata(
  items,
  properties = NULL,
  values = NULL,
  qual.properties = NULL,
  qual.values = NULL,
  src.properties = NULL,
  src.values = NULL,
  remove = FALSE,
  format = "tibble",
  api.username = NULL,
  api.token = NULL,
  api.format = "v1",
  api.batchname = NULL,
  api.submit = TRUE
)
}
\arguments{
\item{items}{a vector of strings indicating the items to which to add statements (as QIDs or labels).
Note: if labels are provided, and multiple items match, the first matching item will be used
(see \code{as_qid} function), so use with caution.
New QIDs can be created by using the "CREATE_xyz", where "_xyz" is any unique string.
Using the same id will add additional statemnts to those new items}

\item{properties}{a vector of strings indicating the properties to add as statements (as PIDs or labels).
Note: if labels are provided, and multiple items match, the first matching item will be used
(see \code{as_pid} function), so use with caution.
Four special properties can also be used: labels, aliases, descriptions and sitelinks.
See [this link](https://www.wikidata.org/wiki/Help:QuickStatements#Adding_labels,_aliases,_descriptions_and_sitelinks) for the syntax.}

\item{values}{a vector of strings indicating the values to add as statements (as QIDs or strings).
Note: if strings are provided, they will be treated as plain text.}

\item{qual.properties}{a vector, data frame, or tibble of strings indicating the properties to add as qualifiers to statements (as PIDs or labels).
Note: if labels are provided, and multiple items match, the first matching item will be used
(see \code{as_pid} function), so use with caution.}

\item{qual.values}{a vector, data frame, or tibble of strings indicating the values to add as statements (as QIDs or strings).
Note: if strings are provided, they will be treated as plain text.}

\item{src.properties}{a vector, data frame, or tibble of strings indicating the properties to add as reference sources to statements (as SIDs or labels).
Note: if labels are provided, and multiple items match, the first matching item will be used
(see \code{as_sid} function), so use with caution.}

\item{src.values}{a vector, data frame, or tibble of strings indicating the values to add reference sources to statements (as QIDs or strings).
Note: if strings are provided, they will be treated as plain text.}

\item{remove}{a vector of boolians for each statemnt indicating whether it should
be removed from the item rather than added (default = FALSE)}

\item{format}{output format as a string. Options include:
\describe{
  \item{tibble}{easiest format to further manuipulation in R}
  \item{csv}{can be copy-pasted to [the QuickStatements website](https://quickstatements.toolforge.org/) (or manipulated in a spreadsheet programs)}
  \item{api}{a url that can be copy-pasted into a web browser, or automatically submitted (see \code{api.submit} parameter)}
}}

\item{api.username}{a string indicating your wikimedia username}

\item{api.token}{a string indicating your api token (the unique identifier that you can find listed at [your user page](https://quickstatements.toolforge.org/#/user))}

\item{api.format}{a string indicateing which version of the quickstatement format used to submit the api (default = "v1")}

\item{api.batchname}{a string create a named batch (listed at [your batch history page](https://quickstatements.toolforge.org/#/batches)) and tag in the edit summaries}

\item{api.submit}{boolian indicating whether to submit instruction directly to wikidata (else returns the URL that can be copy-pasted into a web browser)}
}
\value{
data formatted to upload to wikidata (via quickstatemsnts),
optionally also directly uploded to wikidata (see \code{format} parameter.
}
\description{
Upload data to wikidata, including creating items,
adding statements to existing items (via the quickstatements format and API).
}
\examples{
# Add a statement to the "Wikidata sandbox" item (Q4115189)
# to say that it is an "instance of" (P31) of Q1 (the universe).
# The instruction will submit directly to wikidata via the API
# (if you include your wikimedia username and token)

\donttest{write_wikidata(items        = "Wikidata Sandbox",
               properties   = "instance of",
               values       = "Q1",
               format       = "api",
               api.username = "myusername", 
               api.token    = , #REDACTED#
               )}
#note: 

}
