% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wordcloud.R
\name{plot_wordcloud}
\alias{plot_wordcloud}
\title{Wordclouds for 'WhatsApp' chat logs}
\usage{
plot_wordcloud(
  data,
  names = "all",
  starttime = "1960-01-01 00:00",
  endtime = as.character(as.POSIXct(Sys.time(), tz = "UTC")),
  remove_stops = TRUE,
  stop = "english",
  comparison = FALSE,
  return_data = FALSE,
  font_size = 10,
  min_occur = 5,
  exclude_sm = FALSE
)
}
\arguments{
\item{data}{A 'WhatsApp' chat log that was parsed with \code{\link[WhatsR]{parse_chat}} and anonimize = FALSE or anonimize = "add"}

\item{names}{A vector of author names that the plots will be restricted to.}

\item{starttime}{Datetime that is used as the minimum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{endtime}{Datetime that is used as the maximum boundary for exclusion. Is parsed with \code{\link[anytime]{anytime}}. Standard format is "yyyy-mm-dd hh:mm". Is interpreted as UTC to be compatible with 'WhatsApp' timestamps.}

\item{remove_stops}{Either TRUE or FALSE, default is TRUE. Configures whether stopwords from \code{\link[tm]{stopwords}} are removed from the text strings.}

\item{stop}{The language for stopword removal. Stopwords are taken from \code{\link[tm]{stopwords}}. Options are "english" and "german".}

\item{comparison}{Must be TRUE or FALSE. If TRUE, will split up wordcloud by sender. Default is FALSE.}

\item{return_data}{Will return the data frame used to create the plot if TRUE. Default is FALSE.}

\item{font_size}{Size of the words in the wordcloud, passed to \code{\link[ggplot2]{scale_size_area}}. Default is 10, a good starting value is 0.0125 * number of messages in data frame.}

\item{min_occur}{Sets the minimum frequency a token must occur in the chat for it to be included in the plot. Default is 5.}

\item{exclude_sm}{If TRUE, excludes the 'WhatsApp' system messages from word clouds. Default is FALSE.}
}
\value{
A wordcloud plot per author for 'WhatsApp' chat logs
}
\description{
Creates a wordcloud by author for 'WhatsApp' chat logs. Requires raw message text to be present in data.
}
\examples{
data <- readRDS(system.file("ParsedWhatsAppChat.rds", package = "WhatsR"))
plot_wordcloud(data, comparison = TRUE, min_occur = 6)
}
