% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_weightit-methods.R
\name{glm_weightit-methods}
\alias{glm_weightit-methods}
\alias{summary.glm_weightit}
\alias{summary.multinom_weightit}
\alias{summary.ordinal_weightit}
\alias{summary.coxph_weightit}
\alias{print.glm_weightit}
\alias{vcov.glm_weightit}
\alias{anova.glm_weightit}
\title{Methods for \code{glm_weightit()} objects}
\usage{
\method{summary}{glm_weightit}(object, ci = FALSE, level = 0.95, transform = NULL, ...)

\method{summary}{multinom_weightit}(object, ci = FALSE, level = 0.95, transform = NULL, ...)

\method{summary}{ordinal_weightit}(
  object,
  ci = FALSE,
  level = 0.95,
  transform = NULL,
  thresholds = TRUE,
  ...
)

\method{summary}{coxph_weightit}(object, ci = FALSE, level = 0.95, transform = NULL, ...)

\method{print}{glm_weightit}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{vcov}{glm_weightit}(object, complete = TRUE, ...)

\method{anova}{glm_weightit}(object, object2, test = "Chisq", method = "Wald", tolerance = 1e-07, ...)
}
\arguments{
\item{object, object2, x}{an output from one of the above modeling functions. For \code{anova()}, \code{object2} is required.}

\item{ci}{\code{logical}; whether to display Wald confidence intervals for estimated coefficients. Default is \code{FALSE}.}

\item{level}{when \code{ci = TRUE}, the desired confidence level.}

\item{transform}{the function used to transform the coefficients, e.g., \code{exp} (which can also be supplied as a string, e.g., \code{"exp"}); passed to \code{\link[=match.fun]{match.fun()}} before being used on the coefficients. When \code{ci = TRUE}, this is also applied to the confidence interval bounds. If specified, the standard error will be omitted from the output. Default is no transformation.}

\item{\dots}{ignored.}

\item{thresholds}{\code{logical}; whether to include thresholds in the \code{summary()} output for \code{ordinal_weightit} objects. Default is \code{TRUE}.}

\item{digits}{the number of \emph{significant} digits to be
    passed to \code{\link{format}(\link[stats]{coef}(x), .)} when
    \code{\link{print}()}ing.}

\item{complete}{\code{logical}; whether the full variance-covariance matrix should be returned also in case of an over-determined system where some coefficients are undefined and \code{coef(.)} contains \code{NA}s correspondingly. When \code{complete = TRUE}, \code{vcov()} is compatible with \code{coef()} also in this singular case.}

\item{test}{the type of test statistic used to compare models. Currently only \code{"Chisq"} (the chi-square statistic) is allowed.}

\item{method}{the kind of test used to compare models. Currently only \code{"Wald"} is allowed.}

\item{tolerance}{for the Wald test, the tolerance used to determine if models are symbolically nested.}
}
\value{
\code{summary()} returns a \code{summary.glm_weightit()} object, which has its own print method. For \code{coxph_weightit()} objects, the \code{print()} and \code{summary()} methods are more like those for \code{glm} objects then for \code{coxph} objects.

Otherwise, all methods return the same type of object as their generics.
}
\description{
This page documents methods for objects returned by \code{\link[=glm_weightit]{glm_weightit()}}, \code{lm_weightit()}, \code{ordinal_weightit()}, \code{multinom_weightit()}, and \code{coxph_weightit()}. \code{predict()} methods are described at \code{\link[=predict.glm_weightit]{predict.glm_weightit()}}.
}
\details{
\code{vcov()} (which is called by \code{summary()}) simply extracts the covariance matrix already computed by the fitting function. \code{confint()} computes Wald confidence intervals (internally calling \code{\link[=confint.lm]{confint.lm()}}). The \code{estfun()} method for \code{multinom_weightit} and \code{ordinal_weightit} objects (which is used by function in the \pkg{sandwich} package to compute coefficient covariance matrices) simply extracts the \code{gradient} component of the object. For \code{glm_weightit} and \code{coxph_weightit} objects, the \code{glm} and \code{coxph} methods are dispatched instead.

\code{anova()} performs a Wald test to compare two fitted models. The models must be nested, but they don't have to be nested symbolically (i.e., the names of the coefficients of the smaller model do not have to be a subset of the names of the coefficients of the larger model). The larger model must be supplied to \code{object} and the smaller to \code{object2}. Both models must contain the same units, weights (if any), and outcomes. The variance-covariance matrix of the coefficients of the smaller model is not used, so it can be specified as \code{"none"} in the original model call. Otherwise, a warning be thrown if the covariances were computed using different methods.
}
\examples{
## See more examples at ?glm_weightit

data("lalonde", package = "cobalt")

# Model comparison for any relationship between `treat`
# and `re78` (not the same as testing for the ATE)
fit1 <- glm_weightit(
  re78 ~ treat * (age + educ + race + married + nodegree +
                    re74 + re75), data = lalonde
)

fit2 <- glm_weightit(
  re78 ~ age + educ + race + married + nodegree +
    re74 + re75, data = lalonde
)

anova(fit1, fit2)

\dontshow{if (requireNamespace("splines", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Model comparison between spline model and linear
# model; note they are nested but not symbolically
# nested
fit_s <- glm_weightit(
  re78 ~ splines::ns(age, df = 4), data = lalonde
)

fit_l <- glm_weightit(
  re78 ~ age, data = lalonde
)

anova(fit_s, fit_l)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=glm_weightit]{glm_weightit()}} for the page documenting \code{glm_weightit()}, \code{lm_weightit()}, \code{ordinal_weightit()}, \code{multinom_weightit()}, and \code{coxph_weightit()}. \code{\link[=summary.glm]{summary.glm()}}, \link{vcov}, \code{\link[=confint]{confint()}} for the relevant methods pages. \code{\link[=predict.glm_weightit]{predict.glm_weightit()}} for computing predictions from the models.
}
