% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delpts_tracked_period_wt.R
\name{delpts_tracked_period_wt}
\alias{delpts_tracked_period_wt}
\title{Remove tracking points which were tracked in a wavelet spectra}
\usage{
delpts_tracked_period_wt(
  tracking_pts = NULL,
  wavelet = NULL,
  n.levels = 100,
  periodlab = "Period (metres)",
  x_lab = "depth (metres)",
  palette_name = "rainbow",
  color_brewer = "grDevices"
)
}
\arguments{
\item{tracking_pts}{Points tracked using the \code{\link{track_period_wavelet}} function.}

\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{n.levels}{Number of color levels \code{Default=100}.}

\item{periodlab}{label for the y-axis \code{Default="Period (metres)"}.}

\item{x_lab}{label for the x-axis \code{Default="depth (metres)"}.}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}
}
\value{
The results of the deletion of the tracking points is a matrix with 3 columns.
The first column is depth/time
The second column is the period of the tracked cycle
The third column is the sedimentation rate based on the duration (in time) of the tracked cycle
}
\description{
Interactively select points for deletion
With the  \code{\link{track_period_wavelet}} function it is possible to track points in a wavelet spectra,
however errors can be made and as such it is possible to delete these points with the \code{\link{delpts_tracked_period_wt}} function.
This function allows one to select points for deletion.
#'
}
\examples{
\donttest{
#Track the 405kyr eccentricity cycle in the magnetic susceptibility record
# of the Sullivan core of Pas et al., (2018)

mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#mag_track <- track_period_wavelet(astro_cycle = 405,
#                                   wavelet=mag_wt,
#                                   n.levels = 100,
#                                   periodlab = "Period (metres)",
#                                   x_lab = "depth (metres)"
#                                    palette_name ="rainbow",
#                                    color_brewer ="grDevices)

#load the mag_track_solution data set to get an example data set from which
#data points can be deleted


mag_track_corr <- delpts_tracked_period_wt(tracking_pts = mag_track_solution,
                                    wavelet = mag_wt,
                                    n.levels = 100,
                                    periodlab = "Period (metres)",
                                    x_lab = "depth (metres)",
                                   palette_name ="rainbow",
                                   color_brewer ="grDevices")
}

}
