% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_signal_standard_deviation.R
\name{extract_signal_standard_deviation}
\alias{extract_signal_standard_deviation}
\title{Extract a signal using standard deviation}
\usage{
extract_signal_standard_deviation(
  wavelet = NULL,
  tracked_cycle_curve = NULL,
  multi = 1,
  extract_cycle = NULL,
  tracked_cycle_period = NULL,
  add_mean = TRUE,
  tune = FALSE,
  genplot_uncertainty_wt = FALSE,
  genplot_extracted = FALSE,
  keep_editable = FALSE,
  palette_name = "rainbow",
  color_brewer = "grDevices"
)
}
\arguments{
\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{tracked_cycle_curve}{Curve of the cycle tracked using the
\code{\link{track_period_wavelet}} function. Any input (matrix or data frame)
 in which the first column is depth or time and the second column is period should work.}

\item{multi}{multiple of the standard deviation to be used as boundaries for the cycle extraction
\code{Default=1}.}

\item{extract_cycle}{Period of the cycle to be extracted.}

\item{tracked_cycle_period}{Period of the tracked cycle.}

\item{add_mean}{Add mean to the extracted cycle \code{Default=TRUE}.}

\item{tune}{Tune data set using the \code{Default=tracked_cycle_curve} curve \code{Default=FALSE}.}

\item{genplot_uncertainty_wt}{Generate a wavelet spectra plot with the tracked curve and its
analytical uncertainty based the Gabor uncertainty principle applied
continuous wavelet transform using a Morlet wavelet on superimposed on top of it.
In the plot the red curve and blue curves are the upper and lower bounds
based on the \code{multi} parameter which x-times the standard deviation of uncertainty.
The black curve is the \code{Default=FALSE} curve.}

\item{genplot_extracted}{Generates a plot with the data set and
the extracted cycle on top \code{Default=FALSE} of it.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}
}
\value{
Signal extracted from the wavelet spectra.
Output is a matrix with the first column being depth/time
and the second column is the astronomical cycle extracted from the proxy record

If \code{genplot_uncertainty_wt=TRUE} then a wavelet spectra will be plotted
with the uncertainty superimposed on top of it. In the plot the red curve and
blue curves are the upper and lower bounds
based on the \code{multi} parameter.The black curve is the \code{Default=tracked_cycle_curve} curve.
If \code{genplot_extracted=TRUE} plot with the data set and
the extracted cycle on top of it will be plotted.
}
\description{
Extract signal from a
wavelet spectra in the depth domain using a the standard deviation of the omega (number of cycles)
as boundaries. The uncertainty is based on the Gabor uncertainty principle applied to the
continuous wavelet transform using a Morlet wavelet. The calculated uncertainty is the underlying
analytical uncertainty which is the result of applying the Gabor uncertainty principle to the
continuous wavelet transform using a Morlet wavelet.
}
\examples{
\donttest{
#Extract the 405 kyr eccentricity cycle from the magnetic susceptibility
#record of the Sullivan core of Pas et al., (2018) and use the Gabor
# uncertainty principle to define the mathematical uncertainty of the
# analysis and use a factor of that standard deviation to define
# boundaries

# perform the CWT
mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#Track the 405 kyr eccentricity cycle in a wavelet spectra

#mag_track <- track_period_wavelet(astro_cycle = 405,
#                                   wavelet=mag_wt,
#                                   n.levels = 100,
#                                   periodlab = "Period (metres)",
#                                   x_lab = "depth (metres)",
#                                   palette_name="rainbow",
#                                   color_brewer="grDevices")

#Instead of tracking, the tracked solution data set mag_track_solution is used
mag_track <- mag_track_solution

mag_track_complete <- completed_series(
  wavelet = mag_wt,
  tracked_curve = mag_track,
  period_up = 1.2,
  period_down = 0.8,
  extrapolate = TRUE,
  genplot = FALSE
)

# smooth the tracking of the 405 kyr eccentricity cycle
mag_track_complete <- loess_auto(time_series = mag_track_complete,
genplot = FALSE, print_span = FALSE)

# extract the 405 kyr eccentricity cycle from the wavelet spectrum and use
# the Gabor uncertainty principle to define the mathematical uncertainty of
# the analysis and use a multiple of the derived standard deviation to define boundaries

mag_405_ecc <- extract_signal_standard_deviation(
wavelet = mag_wt,
tracked_cycle_curve = mag_track_complete,
multi = 1,
extract_cycle = 405,
tracked_cycle_period = 405,
add_mean = TRUE,
tune = FALSE,
genplot_uncertainty_wt = FALSE,
genplot_extracted = FALSE,
keep_editable=FALSE,
palette_name="rainbow",
color_brewer="grDevices"
)
}
}
\references{
Angi Roesch and Harald Schmidbauer (2018). WaveletComp: Computational
Wavelet Analysis. R package version 1.1.
\url{https://CRAN.R-project.org/package=WaveletComp}

Gouhier TC, Grinsted A, Simko V (2021). R package biwavelet: Conduct Univariate and Bivariate Wavelet Analyses. (Version 0.20.21),
\url{https://github.com/tgouhier/biwavelet}

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
Bulletin of the American Meteorological Society 79:61-78.
\url{https://paos.colorado.edu/research/wavelets/bams_79_01_0061.pdf}

Gabor, Dennis. "Theory of communication. Part 1: The analysis of information."
Journal of the Institution of Electrical Engineers-part III: radio and
communication engineering 93, no. 26 (1946): 429-441.\url{http://genesis.eecg.toronto.edu/gabor1946.pdf}

Russell, Brian, and Jiajun Han. "Jean Morlet and the continuous wavelet transform.
" CREWES Res. Rep 28 (2016): 115. \url{https://www.crewes.org/Documents/ResearchReports/2016/CRR201668.pdf}


Morlet, Jean, Georges Arens, Eliane Fourgeau, and Dominique Glard.
"Wave propagation and sampling theory—Part I: Complex signal and scattering in multilayered media.
" Geophysics 47, no. 2 (1982): 203-221.
<\doi{doi:10.1190/1.1441328}>

J. Morlet, G. Arens, E. Fourgeau, D. Giard;
Wave propagation and sampling theory; Part II, Sampling theory and complex waves.
 Geophysics 1982 47 (2): 222–236. <\doi{doi:10.1190/1.1441329}>
}
\author{
Code based on the \link[WaveletComp]{reconstruct} function of the 'WaveletComp' R package
which is based on the wavelet 'MATLAB' code written by Christopher Torrence and Gibert P. Compo (1998).
The assignment of the standard deviation of the uncertainty of the wavelet
is based on the work of Gabor (1946) and Russell et al., (2016)
}
